/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import jmri.jmrix.rps.Reading;

public class Measurement {
    boolean valid = true;
    double x;
    double y;
    double z;
    double vsound;
    protected int code;
    String source;
    Reading r;

    public Measurement(Reading r) {
        this.r = r;
    }

    public Measurement(Reading r, double x, double y, double z, double vsound, int code, String source) {
        this(r);
        this.x = x;
        this.y = y;
        this.z = z;
        this.vsound = vsound;
        this.code = code;
        this.source = source;
    }

    public Reading getReading() {
        return this.r;
    }

    public String getId() {
        if (this.r == null) {
            return "<none>";
        }
        return this.r.getId();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getVSound() {
        return this.vsound;
    }

    public boolean isValidPosition() {
        if (!this.valid) {
            return false;
        }
        return !(Math.abs(this.x) > 1.0E10 || Math.abs(this.y) > 1.0E10 || Math.abs(this.z) > 1.0E10);
    }

    public void setValidPosition(boolean val) {
        this.valid = val;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isOkPoint() {
        return this.getCode() > 0;
    }

    public String textCode() {
        return "" + this.getCode();
    }

    public Point3d getPoint() {
        return new Point3d(this.x, this.y, this.z);
    }

    public Vector3d getVector() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        if (!this.isValidPosition()) {
            return "Measurement id=" + this.getId() + " invalid position";
        }
        return "Measurement id=" + this.getId() + " position= " + this.truncate(this.x) + ", " + this.truncate(this.y) + ", " + this.truncate(this.z);
    }

    double truncate(double x) {
        return (double)((int)Math.round(x * 10.0)) / 10.0;
    }
}

