/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import javax.vecmath.Point3d;
import jmri.jmrix.rps.Calculator;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialAlgorithm
implements Calculator {
    double vsound;
    Point3d sensor1;
    Point3d sensor2;
    Point3d sensor3;
    Point3d sensor4;
    double x;
    double y;
    double z;
    double x0;
    double y0;
    double z0;
    double r0;
    int ngps;
    double xi;
    double yi;
    double zi;
    double xj;
    double yj;
    double zj;
    double xk;
    double yk;
    double zk;
    double xl;
    double yl;
    double zl;
    double ri;
    double rj;
    double rk;
    double rl;
    private static final Logger log = LoggerFactory.getLogger(InitialAlgorithm.class);

    public InitialAlgorithm(Point3d[] sensors, double vsound) {
        this(sensors[0], sensors[1], sensors[2], sensors[3], vsound);
    }

    public InitialAlgorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, double vsound) {
        this.sensor1 = sensor1;
        this.sensor2 = sensor2;
        this.sensor3 = sensor3;
        this.vsound = vsound;
        this.xi = sensor1.x;
        this.yi = sensor1.y;
        this.zi = sensor1.z;
        this.xj = sensor2.x;
        this.yj = sensor2.y;
        this.zj = sensor2.z;
        this.xk = sensor3.x;
        this.yk = sensor3.y;
        this.zk = sensor3.z;
        this.ngps = 3;
    }

    public InitialAlgorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, Point3d sensor4, double vsound) {
        this(sensor1, sensor2, sensor3, vsound);
        this.sensor4 = sensor4;
        this.xl = sensor4.x;
        this.yl = sensor4.y;
        this.zl = sensor4.z;
        this.ngps = 4;
    }

    @Override
    public Measurement convert(Reading r) {
        this.ngps = r.getNValues();
        this.ri = r.getValue(1) * this.vsound;
        this.rj = r.getValue(2) * this.vsound;
        this.rk = r.getValue(3) * this.vsound;
        if (r.getNValues() > 3) {
            this.rl = r.getValue(4) * this.vsound;
        }
        log.debug("inputs {} {} {} {}", new Object[]{this.ri, this.rj, this.rk, this.rl});
        this.gps();
        log.debug("x = {} y = {} z0 = {}", new Object[]{this.x0, this.y0, this.z0});
        return new Measurement(r, this.x0, this.y0, this.z0, this.vsound, -99, "Initial");
    }

    @Override
    public Measurement convert(Reading r, Point3d guess) {
        this.x = guess.x;
        this.y = guess.y;
        this.z = guess.z;
        return this.convert(r);
    }

    @Override
    public Measurement convert(Reading r, Measurement last) {
        if (last != null) {
            this.x = last.getX();
            this.y = last.getY();
            this.z = last.getZ();
        }
        if (this.x > 9.0E99) {
            this.x = 0.0;
        }
        if (this.y > 9.0E99) {
            this.y = 0.0;
        }
        if (this.z > 9.0E99) {
            this.z = 0.0;
        }
        return this.convert(r);
    }

    boolean gps() {
        double e2;
        double e1;
        double z2;
        double y2;
        double x2;
        double z1;
        double y1;
        double x1;
        this.r0 = 9.9999999E99;
        this.z0 = 9.9999999E99;
        this.y0 = 9.9999999E99;
        this.x0 = 9.9999999E99;
        double r01 = -1.0;
        double r02 = -1.0;
        if (this.ngps == 3) {
            double xik = this.xi - this.xk;
            double yik = this.yi - this.yk;
            double zik = this.zi - this.zk;
            log.debug("xik={} yik={}", (Object)xik, (Object)yik);
            double xjk = this.xj - this.xk;
            double yjk = this.yj - this.yk;
            double zjk = this.zj - this.zk;
            log.debug("xjk={} yjk={}", (Object)xjk, (Object)yjk);
            double Ci = (this.xi * this.xi - this.xk * this.xk + this.yi * this.yi - this.yk * this.yk + this.zi * this.zi - this.zk * this.zk - this.ri * this.ri + this.rk * this.rk) / 2.0;
            double Cj = (this.xj * this.xj - this.xk * this.xk + this.yj * this.yj - this.yk * this.yk + this.zj * this.zj - this.zk * this.zk - this.rj * this.rj + this.rk * this.rk) / 2.0;
            double Dz = xik * yjk - xjk * yik;
            double Dy = zik * xjk - zjk * xik;
            double Dx = yik * zjk - yjk * zik;
            if (Math.abs(Dx) > Math.abs(Dy) && Math.abs(Dx) > Math.abs(Dz)) {
                log.debug("case 1");
                double Ay = (zik * xjk - zjk * xik) / Dx;
                double By = (zjk * Ci - zik * Cj) / Dx;
                double Az = (yjk * xik - yik * xjk) / Dx;
                double Bz = (yik * Cj - yjk * Ci) / Dx;
                double Ax = Ay * Ay + Az * Az + 1.0;
                double Bx = (Ay * (this.yk - By) + Az * (this.zk - Bz) + this.xk) / Ax;
                double Cx = Bx * Bx - (By * By + Bz * Bz - 2.0 * this.yk * By - 2.0 * this.zk * Bz + this.yk * this.yk + this.zk * this.zk + this.xk * this.xk - this.rk * this.rk) / Ax;
                if (Cx < 0.0) {
                    log.warn("Cx is {}, less than 0, in 3 sensor case", (Object)Cx);
                    return false;
                }
                x1 = Bx + Math.sqrt(Cx);
                y1 = Ay * x1 + By;
                z1 = Az * x1 + Bz;
                x2 = 2.0 * Bx - x1;
                y2 = Ay * x2 + By;
                z2 = Az * x2 + Bz;
            } else if (Math.abs(Dy) > Math.abs(Dz)) {
                log.debug("case 2");
                double Az = (xik * yjk - xjk * yik) / Dy;
                double Bz = (xjk * Ci - xik * Cj) / Dy;
                double Ax = (zjk * yik - zik * yjk) / Dy;
                double Bx = (zik * Cj - zjk * Ci) / Dy;
                double Ay = Az * Az + Ax * Ax + 1.0;
                double By = (Az * (this.zk - Bz) + Ax * (this.xk - Bx) + this.yk) / Ay;
                double Cy = By * By - (Bz * Bz + Bx * Bx - 2.0 * this.zk * Bz - 2.0 * this.xk * Bx + this.zk * this.zk + this.xk * this.xk + this.yk * this.yk - this.rk * this.rk) / Ay;
                if (Cy < 0.0) {
                    log.warn("Cy is {}, less than 0, in 3 sensor case", (Object)Cy);
                    return false;
                }
                y1 = By + Math.sqrt(Cy);
                z1 = Az * y1 + Bz;
                x1 = Ax * y1 + Bx;
                y2 = 2.0 * By - y1;
                z2 = Az * y2 + Bz;
                x2 = Ax * y2 + Bx;
            } else {
                log.debug("case 3");
                if (Dz == 0.0) {
                    log.warn("Dz is 0 in 3 sensor case");
                    return false;
                }
                double Ax = (yik * zjk - yjk * zik) / Dz;
                double Bx = (yjk * Ci - yik * Cj) / Dz;
                double Ay = (xjk * zik - xik * zjk) / Dz;
                double By = (xik * Cj - xjk * Ci) / Dz;
                double Az = Ax * Ax + Ay * Ay + 1.0;
                double Bz = (Ax * (this.xk - Bx) + Ay * (this.yk - By) + this.zk) / Az;
                double Cz = Bz * Bz - (Bx * Bx + By * By - 2.0 * this.xk * Bx - 2.0 * this.yk * By + this.xk * this.xk + this.yk * this.yk + this.zk * this.zk - this.rk * this.rk) / Az;
                if (Cz < 0.0) {
                    log.warn("Cz is {}, less than 0, in 3 sensor case", (Object)Cz);
                    return false;
                }
                z1 = Bz + Math.sqrt(Cz);
                x1 = Ax * z1 + Bx;
                y1 = Ay * z1 + By;
                z2 = 2.0 * Bz - z1;
                x2 = Ax * z2 + Bx;
                y2 = Ay * z2 + By;
                log.debug("x1 = {}", (Object)x1);
                log.debug("x2 = {}", (Object)x2);
            }
        } else if (this.ngps == 4) {
            double xie = this.xi + 1.0E-9;
            double yie = this.yi - 7.0E-9;
            double zie = this.zi - 4.0E-9;
            double rie = this.ri + 6.0E-9;
            double xje = this.xj + 5.0E-9;
            double yje = this.yj - 3.0E-9;
            double zje = this.zj + 2.0E-9;
            double rje = this.rj - 8.0E-9;
            double xke = this.xk - 2.0E-9;
            double yke = this.yk - 6.0E-9;
            double zke = this.zk + 7.0E-9;
            double rke = this.rk - 5.0E-9;
            double xle = this.xl + 8.0E-9;
            double yle = this.yl + 4.0E-9;
            double zle = this.zl - 1.0E-9;
            double rle = this.rl + 3.0E-9;
            double xij = xie - xje;
            double xik = xie - xke;
            double xjk = xje - xke;
            double xkl = xke - xle;
            double yij = yie - yje;
            double yik = yie - yke;
            double yjk = yje - yke;
            double ykl = yke - yle;
            double zij = zie - zje;
            double zik = zie - zke;
            double zjk = zje - zke;
            double zkl = zke - zle;
            double rij = rie - rje;
            double rik = rie - rke;
            double rjk = rje - rke;
            double rkl = rke - rle;
            double Ci = (rik * (rij * rij + xie * xie - xje * xje + yie * yie - yje * yje + zie * zie - zje * zje) - rij * (rik * rik + xie * xie - xke * xke + yie * yie - yke * yke + zie * zie - zke * zke)) / 2.0;
            double Cj = (rkl * (rjk * rjk + xke * xke - xje * xje + yke * yke - yje * yje + zke * zke - zje * zje) + rjk * (rkl * rkl + xke * xke - xle * xle + yke * yke - yle * yle + zke * zke - zle * zle)) / 2.0;
            double Dx = rik * yij - rij * yik;
            Dx = Dx != 0.0 ? Dx : 1.0E-12;
            double Dy = rjk * ykl - rkl * yjk;
            Dy = Dy != 0.0 ? Dy : 1.0E-12;
            double Ca = (rij * xik - rik * xij) / Dx;
            double Cb = (rij * zik - rik * zij) / Dx;
            double Cc = Ci / Dx;
            double Cd = (rkl * xjk - rjk * xkl) / Dy;
            double Ce = (rkl * zjk - rjk * zkl) / Dy;
            double Cf = Cj / Dy;
            Dx = Ca - Cd;
            Dx = Dx != 0.0 ? Dx : 1.0E-12;
            double Ax = (Ce - Cb) / Dx;
            double Bx = (Cf - Cc) / Dx;
            double Ay = Ca * Ax + Cb;
            double By = Ca * Bx + Cc;
            Ci = rik * rik + xie * xie - xke * xke + yie * yie - yke * yke + zie * zie - zke * zke - 2.0 * Bx * xik - 2.0 * By * yik;
            Cj = 2.0 * (Ax * xik + Ay * yik + zik);
            double Dz = 4.0 * rik * rik * (Ax * Ax + Ay * Ay + 1.0) - Cj * Cj;
            Dz = Dz != 0.0 ? Dz : 1.0E-12;
            double Bz = (4.0 * rik * rik * (Ax * (xie - Bx) + Ay * (yie - By) + zie) - Ci * Cj) / Dz;
            double Cz = Math.abs(Bz * Bz - (4.0 * rik * rik * ((xie - Bx) * (xie - Bx) + (yie - By) * (yie - By) + zie * zie) - Ci * Ci) / Dz);
            z1 = Bz + Math.sqrt(Cz);
            x1 = Ax * z1 + Bx;
            y1 = Ay * z1 + By;
            z2 = 2.0 * Bz - z1;
            x2 = Ax * z2 + Bx;
            y2 = Ay * z2 + By;
            double r0i = Math.sqrt((this.xi - x1) * (this.xi - x1) + (this.yi - y1) * (this.yi - y1) + (this.zi - z1) * (this.zi - z1)) - this.ri;
            double r0j = Math.sqrt((this.xj - x1) * (this.xj - x1) + (this.yj - y1) * (this.yj - y1) + (this.zj - z1) * (this.zj - z1)) - this.rj;
            double r0k = Math.sqrt((this.xk - x1) * (this.xk - x1) + (this.yk - y1) * (this.yk - y1) + (this.zk - z1) * (this.zk - z1)) - this.rk;
            double r0l = Math.sqrt((this.xl - x1) * (this.xl - x1) + (this.yl - y1) * (this.yl - y1) + (this.zl - z1) * (this.zl - z1)) - this.rl;
            r01 = (r0i + r0j + r0k + r0l) / 4.0;
            e1 = Math.sqrt(((r0i - r01) * (r0i - r01) + (r0j - r01) * (r0j - r01) + (r0k - r01) * (r0k - r01) + (r0l - r01) * (r0l - r01)) / 4.0);
            log.debug("e1 = {}", (Object)e1);
            if (e1 > 1.0E-4) {
                r01 = 9.9999999E99;
                z1 = 9.9999999E99;
                y1 = 9.9999999E99;
                x1 = 9.9999999E99;
            }
            r0i = Math.sqrt((this.xi - x2) * (this.xi - x2) + (this.yi - y2) * (this.yi - y2) + (this.zi - z2) * (this.zi - z2)) - this.ri;
            r0j = Math.sqrt((this.xj - x2) * (this.xj - x2) + (this.yj - y2) * (this.yj - y2) + (this.zj - z2) * (this.zj - z2)) - this.rj;
            r0k = Math.sqrt((this.xk - x2) * (this.xk - x2) + (this.yk - y2) * (this.yk - y2) + (this.zk - z2) * (this.zk - z2)) - this.rk;
            r0l = Math.sqrt((this.xl - x2) * (this.xl - x2) + (this.yl - y2) * (this.yl - y2) + (this.zl - z2) * (this.zl - z2)) - this.rl;
            r02 = (r0i + r0j + r0k + r0l) / 4.0;
            e2 = Math.sqrt(((r0i - r02) * (r0i - r02) + (r0j - r02) * (r0j - r02) + (r0k - r02) * (r0k - r02) + (r0l - r02) * (r0l - r02)) / 4.0);
            log.debug("e2 = {}", (Object)e2);
            if (e2 > 1.0E-4) {
                r02 = 9.9999999E99;
                z2 = 9.9999999E99;
                y2 = 9.9999999E99;
                x2 = 9.9999999E99;
            }
        } else {
            log.warn("ngps no good: {}", (Object)this.ngps);
            return false;
        }
        e1 = (this.x - x1) * (this.x - x1) + (this.y - y1) * (this.y - y1) + (this.z - z1) * (this.z - z1);
        e2 = (this.x - x2) * (this.x - x2) + (this.y - y2) * (this.y - y2) + (this.z - z2) * (this.z - z2);
        if (e1 <= e2) {
            this.x0 = x1;
            this.y0 = y1;
            this.z0 = z1;
            this.r0 = r01;
        } else {
            this.x0 = x2;
            this.y0 = y2;
            this.z0 = z2;
            this.r0 = r02;
        }
        return true;
    }
}

