/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3d;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrix.rps.Algorithms;
import jmri.jmrix.rps.Calculator;
import jmri.jmrix.rps.Distributor;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.PollingFile;
import jmri.jmrix.rps.PositionFile;
import jmri.jmrix.rps.Reading;
import jmri.jmrix.rps.ReadingListener;
import jmri.jmrix.rps.Receiver;
import jmri.jmrix.rps.Transmitter;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Engine
implements ReadingListener {
    private double vsound = 0.013544;
    private int offset = 0;
    Measurement lastPoint = null;
    Receiver[] receivers;
    String algorithm = "Ash 2.1";
    int pollingInterval = 500;
    boolean polling = false;
    ArrayList<Transmitter> transmitters;
    int pollIndex = -1;
    boolean bscPoll = false;
    boolean throttlePoll = false;
    Thread pollThread;
    boolean pollOutstanding;
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    protected static volatile Engine _instance = null;
    PropertyChangeSupport prop = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(Engine.class);

    void loadValues() {
        this.setInitialAlignment();
        this.loadInitialTransmitters();
    }

    public void dispose() {
    }

    public void setVSound(double v) {
        double oldVal = this.vsound;
        this.vsound = v;
        log.info("change vsound from {} to {}", (Object)oldVal, (Object)v);
        this.prop.firePropertyChange("vSound", oldVal, v);
    }

    public double getVSound() {
        return this.vsound;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setMaxReceiverNumber(int n) {
        log.debug("setReceiverCount to {}", (Object)n);
        if (this.receivers != null && n == this.receivers.length + 1) {
            return;
        }
        Receiver[] oldReceivers = this.receivers;
        this.receivers = new Receiver[n + 1];
        if (oldReceivers == null) {
            return;
        }
        int i = 0;
        while (i < this.receivers.length) {
            this.receivers[i] = null;
            ++i;
        }
        i = 0;
        while (i < Math.min(n + 1, oldReceivers.length)) {
            this.receivers[i] = oldReceivers[i];
            ++i;
        }
    }

    public int getMaxReceiverNumber() {
        if (this.receivers == null) {
            return 0;
        }
        return this.receivers.length - 1;
    }

    public void setReceiver(int address, Receiver receiver) {
        if (this.receivers == null) {
            throw new IllegalArgumentException("Must initialize first");
        }
        if (address >= this.receivers.length) {
            throw new IllegalArgumentException("Index " + address + " is larger than expected " + this.receivers.length);
        }
        log.debug("store receiver {} in {}", (Object)address, (Object)this);
        this.receivers[address] = receiver;
    }

    public Receiver getReceiver(int i) {
        return this.receivers[i];
    }

    public void setReceiverPosition(int i, Point3d p) {
        this.receivers[i].setPosition(p);
    }

    public Point3d getReceiverPosition(int i) {
        if (this.receivers[i] == null) {
            log.debug("getReceiverPosition of null receiver index i={}", (Object)i);
            return null;
        }
        return this.receivers[i].getPosition();
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void notify(Reading r) {
        log.debug("po false {}", (Object)r.getId());
        this.pollOutstanding = false;
        Point3d[] list = new Point3d[this.receivers.length];
        int i = 0;
        while (i < this.receivers.length) {
            if (this.receivers[i] == null) {
                list[i] = null;
            } else {
                Point3d p = this.getReceiverPosition(i);
                if (p != null) {
                    this.receivers[i].setLastTime((int)r.getValue(i));
                    log.debug("    {}th value min {} < time {} < max {} at {}", new Object[]{i, this.receivers[i].getMinTime(), r.getValue(i), this.receivers[i].getMaxTime(), p});
                    list[i] = this.receivers[i].isActive() && (double)this.receivers[i].getMinTime() <= r.getValue(i) && r.getValue(i) <= (double)this.receivers[i].getMaxTime() ? p : null;
                } else {
                    list[i] = null;
                    log.error("Unexpected null position from receiver {}", (Object)i);
                }
            }
            ++i;
        }
        Calculator c = Algorithms.newCalculator(list, this.getVSound(), this.getOffset(), this.getAlgorithm());
        Measurement m = c.convert(r, this.lastPoint);
        this.saveLastMeasurement(r.getId(), m);
        this.lastPoint = m;
        Distributor.instance().submitMeasurement(m);
    }

    void saveLastMeasurement(String id, Measurement m) {
        int i = 0;
        while (i < this.getNumTransmitters()) {
            if (this.getTransmitter(i).getId().equals(id) && this.getTransmitter(i).isPolled()) {
                this.getTransmitter(i).setLastMeasurement(m);
            }
            ++i;
        }
    }

    public void storeAlignment(File file) throws IOException {
        PositionFile pf = new PositionFile();
        pf.prepare();
        pf.setConstants(this.getVSound(), this.getOffset(), this.getAlgorithm());
        int i = 1;
        while (i <= this.getMaxReceiverNumber()) {
            if (this.getReceiver(i) != null) {
                pf.setReceiver(i, this.getReceiver(i));
            }
            ++i;
        }
        pf.store(file);
    }

    public void loadAlignment(File file) throws JDOMException, IOException {
        PositionFile pf = new PositionFile();
        pf.loadFile(file);
        this.setVSound(pf.getVSound());
        this.setOffset(pf.getOffset());
        this.setAlgorithm(pf.getAlgorithm());
        this.setMaxReceiverNumber(pf.maxReceiver());
        int i = 1;
        while (i <= this.getMaxReceiverNumber()) {
            Point3d p = pf.getReceiverPosition(i);
            if (p != null) {
                boolean a = pf.getReceiverActive(i);
                int min = pf.getReceiverMin(i);
                int max = pf.getReceiverMax(i);
                log.debug("load {} with {}", (Object)i, (Object)p);
                Receiver r = new Receiver(p);
                r.setActive(a);
                r.setMinTime(min);
                r.setMaxTime(max);
                this.setReceiver(i, r);
            }
            ++i;
        }
    }

    protected void setInitialAlignment() {
        File defaultFile = new File(PositionFile.defaultFilename());
        try {
            this.loadAlignment(defaultFile);
        }
        catch (Exception e) {
            log.debug("load exception ", (Throwable)e);
            this.setDefaultAlignment();
        }
    }

    protected void setDefaultAlignment() {
        this.setMaxReceiverNumber(2);
        this.setReceiver(1, new Receiver(new Point3d(0.0, 0.0, 72.0)));
        this.setReceiver(2, new Receiver(new Point3d(72.0, 0.0, 72.0)));
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPolling(boolean polling) {
        this.polling = polling;
        if (polling) {
            this.startPoll();
        } else {
            this.stopPoll();
        }
    }

    public boolean getPolling() {
        return this.polling;
    }

    void loadInitialTransmitters() {
        this.transmitters = new ArrayList();
        List<RosterEntry> l = Roster.getDefault().matchingList(null, null, null, null, null, null, null);
        log.debug("Got {} roster entries", (Object)l.size());
        int i = 0;
        while (i < l.size()) {
            RosterEntry r = null;
            try {
                r = l.get(i);
                int address = Integer.parseInt(r.getDccAddress());
                Transmitter t = new Transmitter(r.getId(), false, address, r.isLongAddress());
                t.setRosterName(r.getId());
                this.transmitters.add(t);
            }
            catch (NumberFormatException numberFormatException) {
                if (r != null) {
                    log.warn("Skip roster entry: {}", (Object)r.getId());
                }
                log.warn("Failed roster entry skipped");
            }
            ++i;
        }
        try {
            this.loadPollConfig(new File(PollingFile.defaultFilename()));
        }
        catch (IOException | JDOMException e) {
            log.error("Unable to load {}", (Object)PollingFile.defaultFilename(), (Object)e);
        }
    }

    public void storePollConfig(File file) throws IOException {
        PollingFile pf = new PollingFile();
        pf.prepare();
        pf.setPoll();
        int i = 0;
        while (i < this.getNumTransmitters()) {
            pf.setTransmitter(i);
            ++i;
        }
        pf.store(file);
    }

    public void loadPollConfig(File file) throws JDOMException, IOException {
        if (file.exists()) {
            PollingFile pf = new PollingFile();
            pf.loadFile(file);
            pf.getTransmitters(this);
            pf.getPollValues();
        }
    }

    public Transmitter getTransmitterByAddress(int addr) {
        if (addr < 0) {
            return null;
        }
        if (this.transmitters == null) {
            return null;
        }
        int i = 0;
        while (i < this.getNumTransmitters()) {
            if (this.getTransmitter(i).getAddress() == addr) {
                return this.getTransmitter(i);
            }
            ++i;
        }
        return null;
    }

    public Transmitter getTransmitter(int i) {
        if (i < 0) {
            return null;
        }
        if (this.transmitters == null) {
            return null;
        }
        return this.transmitters.get(i);
    }

    public int getNumTransmitters() {
        if (this.transmitters == null) {
            return 0;
        }
        return this.transmitters.size();
    }

    public String getPolledID() {
        Transmitter t = this.getTransmitter(this.pollIndex);
        if (t == null) {
            return "";
        }
        return t.getId();
    }

    public int getPolledAddress() {
        Transmitter t = this.getTransmitter(this.pollIndex);
        if (t == null) {
            return -1;
        }
        return t.getAddress();
    }

    int selectNextPoll() {
        int startindex = this.pollIndex;
        while (++this.pollIndex < this.getNumTransmitters()) {
            if (!this.getTransmitter(this.pollIndex).isPolled()) continue;
            return this.pollIndex;
        }
        this.pollIndex = -1;
        while (++this.pollIndex <= startindex) {
            if (!this.getTransmitter(this.pollIndex).isPolled()) continue;
            return this.pollIndex;
        }
        return -1;
    }

    public void setBscPollMode() {
        this.bscPoll = true;
        this.throttlePoll = false;
    }

    public void setDirectPollMode() {
        this.bscPoll = false;
        this.throttlePoll = false;
    }

    public void setThrottlePollMode() {
        this.bscPoll = false;
        this.throttlePoll = true;
    }

    public boolean getBscPollMode() {
        return this.bscPoll;
    }

    public boolean getThrottlePollMode() {
        return this.throttlePoll;
    }

    public boolean getDirectPollMode() {
        return !this.bscPoll && !this.throttlePoll;
    }

    void startPoll() {
        this.pollThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                log.debug("Polling starts");
                try {
                    while (true) {
                        int i = Engine.this.selectNextPoll();
                        log.debug("Poll {}", (Object)i);
                        Engine.this.setOn(i);
                        log.debug("po true {}", (Object)i);
                        Engine.this.pollOutstanding = true;
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            this.wait(20L);
                        }
                        Engine.this.setOff(i);
                        log.debug("start wait");
                        Engine.this.waitBeforeNextPoll(Engine.this.pollingInterval);
                        log.debug("end wait");
                    }
                }
                catch (InterruptedException interruptedException) {
                    log.debug("Polling stops");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        this.pollThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitBeforeNextPoll(int pollingInterval) throws InterruptedException {
        Engine engine = this;
        synchronized (engine) {
            this.wait(pollingInterval);
        }
        if (!this.pollOutstanding) {
            return;
        }
        log.debug("--- extra wait");
        int i = 0;
        while (i < 20) {
            Engine engine2 = this;
            synchronized (engine2) {
                this.wait(pollingInterval / 4);
            }
            log.debug("-------------extra wait");
            if (!this.pollOutstanding) {
                return;
            }
            ++i;
        }
    }

    void stopPoll() {
        if (this.pollThread != null) {
            this.pollThread.interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setOn(int i) {
        Transmitter t = this.getTransmitter(i);
        if (this.bscPoll) {
            byte[] packet = NmraPacket.threeBytePacket(t.getAddress(), t.isLongAddress(), (byte)-64, (byte)-91, (byte)-2);
            if (InstanceManager.getNullableDefault(CommandStation.class) == null) return;
            InstanceManager.getDefault(CommandStation.class).sendPacket(packet, 1);
            return;
        } else if (this.throttlePoll) {
            if (!t.checkInit()) return;
            t.getThrottle().setF2(true);
            return;
        } else {
            byte[] packet = NmraPacket.function0Through4Packet(t.getAddress(), t.isLongAddress(), false, false, true, false, false);
            if (InstanceManager.getNullableDefault(CommandStation.class) == null) return;
            InstanceManager.getDefault(CommandStation.class).sendPacket(packet, 1);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setOff(int i) {
        if (this.bscPoll) return;
        Transmitter t = this.getTransmitter(i);
        if (this.throttlePoll) {
            if (!t.checkInit()) return;
            t.getThrottle().setF2(false);
            return;
        } else {
            byte[] packet = NmraPacket.function0Through4Packet(t.getAddress(), t.isLongAddress(), false, false, false, false, false);
            if (InstanceManager.getNullableDefault(CommandStation.class) == null) return;
            InstanceManager.getDefault(CommandStation.class).sendPacket(packet, 1);
        }
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_UPDATE_STATIC"})
    public static Engine instance() {
        if (_instance == null) {
            _instance = new Engine();
            _instance.loadValues();
        }
        return _instance;
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.prop.removePropertyChangeListener(p);
    }

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.prop.addPropertyChangeListener(p);
    }
}

