/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rps;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import javax.vecmath.Point3d;
import jmri.jmrix.rps.AbstractCalculator;
import jmri.jmrix.rps.Measurement;
import jmri.jmrix.rps.Reading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ash2_2Algorithm
extends AbstractCalculator {
    double Vs;
    double Xt = 0.0;
    double Yt = 0.0;
    double Zt = 0.0;
    static int offset = 0;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int TMAX = 35000;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int TMIN = 150;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int SMAX = 30;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int NMAX = 50;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static int NERR = 6;
    private static final Logger log = LoggerFactory.getLogger(Ash2_2Algorithm.class);

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public Ash2_2Algorithm(Point3d[] sensors, double vsound, int offset) {
        this(sensors, vsound);
        Ash2_2Algorithm.offset = offset;
    }

    public Ash2_2Algorithm(Point3d[] sensors, double vsound) {
        this.sensors = Arrays.copyOf(sensors, sensors.length);
        this.Vs = vsound;
    }

    public Ash2_2Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3}, vsound);
    }

    public Ash2_2Algorithm(Point3d sensor1, Point3d sensor2, Point3d sensor3, Point3d sensor4, double vsound) {
        this(new Point3d[]{sensor1, sensor2, sensor3, sensor4}, vsound);
    }

    @Override
    public Measurement convert(Reading r) {
        if (log.isDebugEnabled()) {
            log.debug("Reading: {}", (Object)r);
            log.debug("Sensors: {}", (Object)this.sensors.length);
            if (this.sensors.length >= 1 && this.sensors[0] != null) {
                log.debug("Sensor[0]: {},{},{}", new Object[]{this.sensors[0].x, this.sensors[0].y, this.sensors[0].z});
            }
            if (this.sensors.length >= 2 && this.sensors[1] != null) {
                log.debug("Sensor[1]: {},{},{}", new Object[]{this.sensors[1].x, this.sensors[1].y, this.sensors[1].z});
            }
        }
        this.prep(r);
        RetVal result = this.RPSpos(this.nr, this.Tr, this.Xr, this.Yr, this.Zr, this.Vs, this.Xt, this.Yt, this.Zt);
        this.Xt = result.x;
        this.Yt = result.y;
        this.Zt = result.z;
        this.Vs = result.vs;
        log.debug("x = {} y = {} z0 = {} code = {}", new Object[]{this.Xt, this.Yt, this.Zt, result.code});
        return new Measurement(r, this.Xt, this.Yt, this.Zt, this.Vs, result.code, "Ash2_2Algorithm");
    }

    @Override
    public Measurement convert(Reading r, Point3d guess) {
        this.Xt = guess.x;
        this.Yt = guess.y;
        this.Zt = guess.z;
        return this.convert(r);
    }

    @Override
    public Measurement convert(Reading r, Measurement last) {
        if (last != null) {
            this.Xt = last.getX();
            this.Yt = last.getY();
            this.Zt = last.getZ();
        }
        if (this.Xt > 9.0E99) {
            this.Xt = 0.0;
        }
        if (this.Yt > 9.0E99) {
            this.Yt = 0.0;
        }
        if (this.Zt > 9.0E99) {
            this.Zt = 0.0;
        }
        return this.convert(r);
    }

    RetVal RPSpos(int nr, double[] Tr, double[] Xr, double[] Yr, double[] Zr, double Vs, double Xt, double Yt, double Zt) {
        double q;
        int i = 0;
        int j = 0;
        int jmax = 0;
        int k = 0;
        int l = 0;
        int nox = 0;
        int[] ce = new int[NMAX];
        double[] Rs = new double[NMAX];
        double[] Xs = new double[NMAX];
        double[] Ys = new double[NMAX];
        double[] Zs = new double[NMAX];
        double xo = 0.0;
        double yo = 0.0;
        double zo = 0.0;
        double var = 0.0;
        double[] vex = new double[NERR];
        double vmax = (double)(SMAX * SMAX) * Vs * Vs;
        double vmin = 1.0 * Vs * Vs;
        int ns = 0;
        double Rmax = Vs * (double)TMAX;
        Rs[Ash2_2Algorithm.NMAX - 1] = TMAX;
        i = 0;
        while (i < nr) {
            double Rq;
            if (Tr[i] != 0.0 && !((Rq = Vs * (Tr[i] + (double)offset)) >= Rmax) && !(Rq < Vs * (double)TMIN)) {
                if (ns == 0) {
                    Rs[0] = Rq;
                    Xs[0] = Xr[i];
                    Ys[0] = Yr[i];
                    Zs[0] = Zr[i];
                    ns = 1;
                } else {
                    int n = j = ns == NMAX ? ns - 1 : ns++;
                    while (true) {
                        if (j <= 0 || !(Rq < Rs[j - 1])) {
                            if (j >= NMAX - 1 && !(Rq < Rs[j])) break;
                            Rs[j] = Rq;
                            Xs[j] = Xr[i];
                            Ys[j] = Yr[i];
                            Zs[j] = Zr[i];
                            break;
                        }
                        Rs[j] = Rs[j - 1];
                        Xs[j] = Xs[j - 1];
                        Ys[j] = Ys[j - 1];
                        Zs[j] = Zs[j - 1];
                        --j;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < ns) {
            ce[i] = 0;
            ++i;
        }
        i = 0;
        while (i < ns - 1) {
            j = i + 1;
            while (j < ns) {
                q = Math.sqrt((Xs[i] - Xs[j]) * (Xs[i] - Xs[j]) + (Ys[i] - Ys[j]) * (Ys[i] - Ys[j]) + (Zs[i] - Zs[j]) * (Zs[i] - Zs[j]));
                if (Rs[i] + Rs[j] < q || Rs[i] - Rs[j] > q || Rs[j] - Rs[i] > q) {
                    int n = i;
                    ce[n] = ce[n] + 1;
                    int n2 = j;
                    ce[n2] = ce[n2] + 1;
                }
                ++j;
            }
            ++i;
        }
        int cmax = 1;
        int nxx = 0;
        while (cmax != 0) {
            cmax = 0;
            i = 0;
            while (i < ns) {
                if (ce[i] >= cmax) {
                    if (ce[i] > 0) {
                        nxx = ce[i] == cmax ? nxx + 1 : 1;
                    }
                    cmax = ce[i];
                    j = i;
                }
                ++i;
            }
            if (cmax <= 0) continue;
            i = 0;
            while (i < ns) {
                if (i != j && (Rs[i] + Rs[j] < (q = Math.sqrt((Xs[i] - Xs[j]) * (Xs[i] - Xs[j]) + (Ys[i] - Ys[j]) * (Ys[i] - Ys[j]) + (Zs[i] - Zs[j]) * (Zs[i] - Zs[j]))) || Rs[i] - Rs[j] > q || Rs[j] - Rs[i] > q)) {
                    int n = i;
                    ce[n] = ce[n] - 1;
                }
                ++i;
            }
            i = j;
            while (i < ns - 1) {
                Rs[i] = Rs[i + 1];
                Xs[i] = Xs[i + 1];
                Ys[i] = Ys[i + 1];
                Zs[i] = Zs[i + 1];
                ce[i] = ce[i + 1];
                ++i;
            }
            --ns;
        }
        int nss = ns;
        if (ns < 3) {
            Zt = 9.9999999E99;
            Yt = 9.9999999E99;
            Xt = 9.9999999E99;
            return new RetVal(0, Xt, Yt, Zt, Vs);
        }
        i = 0;
        int S = 0;
        double y = 0.0;
        double x = 0.0;
        double z = -100000.0;
        while (++i < 5000) {
            double w;
            if (S == 0) {
                j = k = (i - 1) % ns;
                w = 1.0;
            } else if (S == 1) {
                j = k = ns - 1 - i % ns;
                w = 1.0;
            } else if (--k < 0) {
                k = 0;
                j = 0;
                w = 0.0;
            } else {
                j = k % ns;
                if (S == 3 && j == l) {
                    j = --k > 0 ? k % ns : 0;
                }
                w = 1.0 - Rs[j] / Rmax;
                w *= w;
                w = k < 50 ? (w *= 0.02 * (double)(k + 1)) : (w *= 0.005 * (double)(k + 150));
            }
            if (k >= 0) {
                q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
                q = w * (1.0 - Rs[j] / q);
                x += q * (Xs[j] - x);
                y += q * (Ys[j] - y);
                z += q * (Zs[j] - z);
            }
            if (S == 1 && i % (50 + ns) == 51 || S >= 2 && k <= 0) {
                double vold = var;
                double emax = 0.0;
                var = 0.0;
                double Zw = 0.0;
                double Yw = 0.0;
                double Xw = 0.0;
                double Ww = 0.0;
                j = 0;
                while (j < ns) {
                    if (S != 3 || j != l) {
                        q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
                        double err = q - Rs[j];
                        err *= err;
                        q = 1.0 - Rs[j] / q;
                        if (S >= 2) {
                            w = 1.0 - Rs[j] / Rmax;
                            w *= w;
                        } else {
                            w = 1.0;
                        }
                        Xw += w * (x + q * (Xs[j] - x));
                        Yw += w * (y + q * (Ys[j] - y));
                        Zw += w * (z + q * (Zs[j] - z));
                        Ww += w;
                        var += w * err;
                        if (w * err > emax) {
                            emax = w * err;
                            jmax = j;
                        }
                    }
                    ++j;
                }
                x = Xw / Ww;
                y = Yw / Ww;
                z = Zw / Ww;
                var /= Ww;
                i += ns - 1;
                if (S == 2 && ns > NERR && var > 3.0 * vmax || S == 4 && ns == 4) {
                    nox = 0;
                    q = Rs[jmax];
                    Rs[jmax] = Rs[--ns];
                    Rs[ns] = q;
                    q = Xs[jmax];
                    Xs[jmax] = Xs[ns];
                    Xs[ns] = q;
                    q = Ys[jmax];
                    Ys[jmax] = Ys[ns];
                    Ys[ns] = q;
                    q = Zs[jmax];
                    Zs[jmax] = Zs[ns];
                    Zs[ns] = q;
                } else {
                    ++nox;
                }
                if (S == 1) {
                    if (var < vmax) {
                        k = 250;
                        nox = 0;
                        S = 6;
                    } else if (var < 3.0 * vmax || i >= 750) {
                        if (ns <= 4) {
                            k = 300;
                            S = var > 36.0 * vmax ? 4 : 5;
                        } else if (ns <= NERR) {
                            l = 0;
                            xo = x;
                            yo = y;
                            zo = z;
                            k = 250;
                            S = 3;
                        } else {
                            k = 200;
                            S = 2;
                        }
                    }
                } else if (S == 2) {
                    if (var < vmax) {
                        k = 300;
                        S = 5;
                    } else if (ns <= NERR) {
                        l = 0;
                        xo = x;
                        yo = y;
                        zo = z;
                        k = 250;
                        S = 3;
                    } else if (i >= 2000) {
                        ns = NERR;
                        l = 0;
                        xo = x;
                        yo = y;
                        zo = z;
                        k = 250;
                        S = 3;
                    }
                    k = 200;
                } else if (S == 3) {
                    if (ns > 4) {
                        vex[l] = var;
                        if (++l < ns) {
                            k = 250;
                            x = xo;
                            y = yo;
                            z = zo;
                        } else {
                            j = 0;
                            var = vex[0];
                            l = 1;
                            while (l < ns) {
                                if (vex[l] < var) {
                                    j = l;
                                    var = vex[j];
                                }
                                ++l;
                            }
                            q = Rs[j];
                            Rs[j] = Rs[--ns];
                            Rs[ns] = q;
                            q = Xs[j];
                            Xs[j] = Xs[ns];
                            Xs[ns] = q;
                            q = Ys[j];
                            Ys[j] = Ys[ns];
                            Ys[ns] = q;
                            q = Zs[j];
                            Zs[j] = Zs[ns];
                            Zs[ns] = q;
                            if (var < vmax) {
                                k = 300;
                                S = 5;
                            } else if (ns <= 4) {
                                k = 300;
                                S = var > 36.0 * vmax ? 4 : 5;
                            } else {
                                l = 0;
                                xo = x;
                                yo = y;
                                zo = z;
                                k = 250;
                            }
                        }
                    }
                } else if (S == 4) {
                    k = 300;
                    S = 5;
                } else if (S == 5) {
                    j = ns;
                    while (j < nss) {
                        q = Math.sqrt((Xs[j] - x) * (Xs[j] - x) + (Ys[j] - y) * (Ys[j] - y) + (Zs[j] - z) * (Zs[j] - z));
                        if ((Rs[j] - q) * (Rs[j] - q) < 4.0 * vmax) {
                            q = Rs[j];
                            Rs[j] = Rs[ns];
                            Rs[ns] = q;
                            q = Xs[j];
                            Xs[j] = Xs[ns];
                            Xs[ns] = q;
                            q = Ys[j];
                            Ys[j] = Ys[ns];
                            Ys[ns] = q;
                            q = Zs[j];
                            Zs[j] = Zs[ns];
                            Zs[ns] = q;
                            ++ns;
                        }
                        ++j;
                    }
                    k = 250;
                    nox = 0;
                    S = 6;
                } else if (S == 6 && nox >= 1 + 110 / (ns + 5) && (var > 0.999 * vold || var < vmin)) break;
            }
            if (S != 0 || i < 50) continue;
            k = j;
            S = 1;
        }
        Xt = x;
        Yt = y;
        Zt = z;
        if (var > vmax || ns == 3 && var > vmin) {
            return new RetVal(-ns, Xt, Yt, Zt, Vs);
        }
        if (ns == 3 && nxx > 1) {
            return new RetVal(1, Xt, Yt, Zt, Vs);
        }
        if (nss >= 3 * ns - 5) {
            return new RetVal(2, Xt, Yt, Zt, Vs);
        }
        return new RetVal(ns, Xt, Yt, Zt, Vs);
    }

    static class RetVal {
        int code;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double x;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double y;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double z;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double t;
        @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
        double vs;

        RetVal(int code, double x, double y, double z, double vs) {
            this.code = code;
            this.x = x;
            this.y = y;
            this.z = z;
            this.vs = vs;
        }
    }
}

