/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.swing.configtool;

import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import jmri.jmrix.roco.z21.RocoZ21CommandStation;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21TrafficController;
import jmri.jmrix.roco.z21.swing.configtool.Bundle;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21ConfigFrame
extends JmriJFrame
implements Z21Listener {
    private Z21TrafficController tc;
    private RocoZ21CommandStation cs;
    private final JToggleButton getSystemInfoButton;
    private JToggleButton setSystemInfoButton;
    private final JToggleButton closeButton;
    private JLabel hardwareVersionLabel;
    private JTextField hardwareVersionTextField;
    private JLabel softwareVersionLabel;
    private JTextField softwareVersionTextField;
    private JLabel serialNumLabel;
    private JTextField serialNumTextField;
    private JCheckBox xPressNetMessagesCheckBox;
    private JCheckBox rmBusMessagesCheckBox;
    private JCheckBox systemStatusMessagesCheckBox;
    private JCheckBox xPressNetLocomotiveMessagesCheckBox;
    private JCheckBox railComMessagesCheckBox;
    private JCheckBox locoNetMessagesCheckBox;
    private JCheckBox locoNetLocomotiveMessagesCheckBox;
    private JCheckBox locoNetTurnoutMessagesCheckBox;
    private JCheckBox locoNetOccupancyMessagesCheckBox;
    private JCheckBox railComAutomaticCheckBox;
    private JCheckBox canDetectorCheckBox;
    private static final Logger log = LoggerFactory.getLogger(Z21ConfigFrame.class);

    public Z21ConfigFrame(Z21SystemConnectionMemo memo) {
        super(Bundle.getMessage("Z21ConfigToolMenuItem"));
        this.tc = memo.getTrafficController();
        this.cs = memo.getRocoZ21CommandStation();
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.getSystemInfoPanel());
        this.getContentPane().add(this.getBroadcastFlagsPanel());
        JPanel buttonPanel = new JPanel();
        this.getSystemInfoButton = new JToggleButton(Bundle.getMessage("GetSystemInfoButtonLabel"));
        this.getSystemInfoButton.setToolTipText(Bundle.getMessage("GetSystemInfoButtonToolTip"));
        this.closeButton = new JToggleButton(Bundle.getMessage("ButtonClose"));
        this.closeButton.setToolTipText(Bundle.getMessage("CloseButtonToolTip"));
        buttonPanel.add(this.getSystemInfoButton);
        buttonPanel.add(this.closeButton);
        this.getContentPane().add(buttonPanel);
        this.addHelpMenu("package.jmri.jmrix.roco.z21.swing.configtool.ConfigToolFrame", true);
        this.pack();
        this.getSystemInfoButton.addActionListener(a -> this.getSystemInfo());
        this.closeButton.addActionListener(a -> {
            this.setVisible(false);
            this.dispose();
        });
        if (this.tc != null) {
            this.tc.addz21Listener(this);
        } else {
            log.warn("No Z21 connection, panel won't function");
        }
    }

    private JPanel getSystemInfoPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SystemInformationTitle")));
        panel.setLayout(new GridLayout(0, 2));
        this.hardwareVersionLabel = new JLabel(Bundle.getMessage("HardwareVersionLabel"));
        this.hardwareVersionTextField = new JTextField("" + this.cs.getHardwareVersion());
        this.hardwareVersionTextField.setEnabled(false);
        panel.add(this.hardwareVersionLabel);
        panel.add(this.hardwareVersionTextField);
        this.softwareVersionLabel = new JLabel(Bundle.getMessage("SoftwareVersionLabel"));
        this.softwareVersionTextField = new JTextField("" + this.cs.getSoftwareVersion());
        this.softwareVersionTextField.setEnabled(false);
        panel.add(this.softwareVersionLabel);
        panel.add(this.softwareVersionTextField);
        this.serialNumLabel = new JLabel(Bundle.getMessage("SerialNumberLabel"));
        this.serialNumTextField = new JTextField("" + this.cs.getSerialNumber());
        this.serialNumTextField.setEnabled(false);
        panel.add(this.serialNumLabel);
        panel.add(this.serialNumTextField);
        return panel;
    }

    private JPanel getBroadcastFlagsPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BroadcastFlagsTitle")));
        panel.setLayout(new GridLayout(0, 1));
        this.xPressNetMessagesCheckBox = new JCheckBox(Bundle.getMessage("XpressNetMessagesFlagLabel"), this.cs.getXPressNetMessagesFlag());
        this.xPressNetMessagesCheckBox.setToolTipText(Bundle.getMessage("XpressNetMessagesFlagToolTip"));
        panel.add(this.xPressNetMessagesCheckBox);
        this.rmBusMessagesCheckBox = new JCheckBox(Bundle.getMessage("RMBusMessagesFlagLabel"), this.cs.getRMBusMessagesFlag());
        this.rmBusMessagesCheckBox.setToolTipText(Bundle.getMessage("RMBusMessagesFlagToolTip"));
        panel.add(this.rmBusMessagesCheckBox);
        this.systemStatusMessagesCheckBox = new JCheckBox(Bundle.getMessage("SystemStatusMessagesFlagLabel"), this.cs.getSystemStatusMessagesFlag());
        this.systemStatusMessagesCheckBox.setToolTipText(Bundle.getMessage("RMBusMessagesFlagToolTip"));
        panel.add(this.systemStatusMessagesCheckBox);
        this.xPressNetLocomotiveMessagesCheckBox = new JCheckBox(Bundle.getMessage("XpressNetLocomotiveMessagesFlagLabel"), this.cs.getXPressNetLocomotiveMessagesFlag());
        this.xPressNetLocomotiveMessagesCheckBox.setToolTipText(Bundle.getMessage("XpressNetLocomotiveMessagesFlagToolTip"));
        panel.add(this.xPressNetLocomotiveMessagesCheckBox);
        this.railComMessagesCheckBox = new JCheckBox(Bundle.getMessage("RailComMessagesFlagLabel"), this.cs.getRailComMessagesFlag());
        this.railComMessagesCheckBox.setToolTipText(Bundle.getMessage("RailComMessagesFlagToolTip"));
        panel.add(this.railComMessagesCheckBox);
        this.railComAutomaticCheckBox = new JCheckBox(Bundle.getMessage("RailComAutomaticFlagLabel"), this.cs.getRailComAutomaticFlag());
        this.railComMessagesCheckBox.setToolTipText(Bundle.getMessage("RailComAutomaticFlagToolTip"));
        panel.add(this.railComAutomaticCheckBox);
        this.locoNetMessagesCheckBox = new JCheckBox(Bundle.getMessage("LocoNetMessagesFlagLabel"), this.cs.getLocoNetMessagesFlag());
        this.locoNetMessagesCheckBox.setToolTipText(Bundle.getMessage("LocoNetMessagesFlagToolTip"));
        panel.add(this.locoNetMessagesCheckBox);
        this.locoNetLocomotiveMessagesCheckBox = new JCheckBox(Bundle.getMessage("LocoNetLocomotiveMessagesFlagLabel"), this.cs.getLocoNetLocomotiveMessagesFlag());
        this.locoNetLocomotiveMessagesCheckBox.setToolTipText(Bundle.getMessage("LocoNetLocomotiveMessagesFlagToolTip"));
        panel.add(this.locoNetLocomotiveMessagesCheckBox);
        this.locoNetTurnoutMessagesCheckBox = new JCheckBox(Bundle.getMessage("LocoNetTurnoutMessagesFlagLabel"), this.cs.getLocoNetTurnoutMessagesFlag());
        this.locoNetTurnoutMessagesCheckBox.setToolTipText(Bundle.getMessage("LocoNetTurnoutMessagesFlagToolTip"));
        panel.add(this.locoNetTurnoutMessagesCheckBox);
        this.locoNetOccupancyMessagesCheckBox = new JCheckBox(Bundle.getMessage("LocoNetOccupancyMessagesFlagLabel"), this.cs.getLocoNetOccupancyMessagesFlag());
        this.locoNetOccupancyMessagesCheckBox.setToolTipText(Bundle.getMessage("LocoNetOccupancyMessagesFlagToolTip"));
        panel.add(this.locoNetOccupancyMessagesCheckBox);
        this.canDetectorCheckBox = new JCheckBox(Bundle.getMessage("canDetectorFlagLabel"), this.cs.getCanDetectorFlag());
        this.canDetectorCheckBox.setToolTipText(Bundle.getMessage("canDetectorFlagToolTip"));
        panel.add(this.canDetectorCheckBox);
        this.setSystemInfoButton = new JToggleButton(Bundle.getMessage("SetSystemInfoButtonLabel"));
        this.setSystemInfoButton.setToolTipText(Bundle.getMessage("SetSystemInfoButtonToolTip"));
        this.setSystemInfoButton.addActionListener(a -> this.writeSystemInfo());
        panel.add(this.setSystemInfoButton);
        return panel;
    }

    private void getSystemInfo() {
        this.tc.sendz21Message(Z21Message.getLanGetHardwareInfoRequestMessage(), this);
        this.tc.sendz21Message(Z21Message.getSerialNumberRequestMessage(), this);
        this.tc.sendz21Message(Z21Message.getLanGetBroadcastFlagsRequestMessage(), this);
    }

    private void writeSystemInfo() {
        this.cs.setXPressNetMessagesFlag(this.xPressNetMessagesCheckBox.isSelected());
        this.cs.setRMBusMessagesFlag(this.rmBusMessagesCheckBox.isSelected());
        this.cs.setSystemStatusMessagesFlag(this.systemStatusMessagesCheckBox.isSelected());
        this.cs.setRailComMessagesFlag(this.railComMessagesCheckBox.isSelected());
        this.cs.setRailComAutomaticFlag(this.railComAutomaticCheckBox.isSelected());
        this.cs.setXPressNetLocomotiveMessagesFlag(this.xPressNetLocomotiveMessagesCheckBox.isSelected());
        this.cs.setLocoNetMessagesFlag(this.locoNetMessagesCheckBox.isSelected());
        this.cs.setLocoNetLocomotiveMessagesFlag(this.locoNetLocomotiveMessagesCheckBox.isSelected());
        this.cs.setLocoNetTurnoutMessagesFlag(this.locoNetTurnoutMessagesCheckBox.isSelected());
        this.cs.setLocoNetOccupancyMessagesFlag(this.locoNetOccupancyMessagesCheckBox.isSelected());
        this.cs.setCanDetectorFlag(this.canDetectorCheckBox.isSelected());
        this.tc.sendz21Message(Z21Message.getLanSetBroadcastFlagsRequestMessage(this.cs.getZ21BroadcastFlags()), this);
    }

    @Override
    public void reply(Z21Reply zr) {
        switch (zr.getOpCode()) {
            case 16: {
                int serialNo = (zr.getElement(4) & 0xFF) + ((zr.getElement(5) & 0xFF) << 8) + ((zr.getElement(6) & 0xFF) << 16) + ((zr.getElement(7) & 0xFF) << 24);
                this.cs.setSerialNumber(serialNo);
                this.updateSerialNumber();
                break;
            }
            case 26: {
                int hwversion = zr.getElement(4) + (zr.getElement(5) << 8) + (zr.getElement(6) << 16) + (zr.getElement(7) << 24);
                this.cs.setHardwareVersion(hwversion);
                float swversion = (float)zr.getElementBCD(8).intValue() / 100.0f + (float)zr.getElementBCD(9).intValue() + (float)(zr.getElementBCD(10) * 100) + (float)(zr.getElementBCD(11) * 10000);
                this.cs.setSoftwareVersion(swversion);
                this.updateVersionInformation();
                break;
            }
            case 81: {
                int flags = zr.getElement(4) + (zr.getElement(5) << 8) + (zr.getElement(6) << 16) + (zr.getElement(7) << 24);
                this.cs.setZ21BroadcastFlags(flags);
                this.updateFlagInformation();
                break;
            }
            default: {
                log.debug("unhandled op-code received.");
            }
        }
    }

    @Override
    public void message(Z21Message zm) {
    }

    @Override
    public void dispose() {
        this.tc.removez21Listener(this);
        super.dispose();
    }

    private void updateVersionInformation() {
        this.hardwareVersionTextField.setText("0x" + Integer.toHexString(this.cs.getHardwareVersion()));
        this.softwareVersionTextField.setText("" + this.cs.getSoftwareVersion());
    }

    private void updateSerialNumber() {
        this.serialNumTextField.setText("" + this.cs.getSerialNumber());
    }

    private void updateFlagInformation() {
        this.xPressNetMessagesCheckBox.setSelected(this.cs.getXPressNetMessagesFlag());
        this.rmBusMessagesCheckBox.setSelected(this.cs.getRMBusMessagesFlag());
        this.systemStatusMessagesCheckBox.setSelected(this.cs.getSystemStatusMessagesFlag());
        this.xPressNetLocomotiveMessagesCheckBox.setSelected(this.cs.getXPressNetLocomotiveMessagesFlag());
        this.railComMessagesCheckBox.setSelected(this.cs.getRailComMessagesFlag());
        this.locoNetMessagesCheckBox.setSelected(this.cs.getLocoNetMessagesFlag());
        this.locoNetLocomotiveMessagesCheckBox.setSelected(this.cs.getLocoNetLocomotiveMessagesFlag());
        this.locoNetTurnoutMessagesCheckBox.setSelected(this.cs.getLocoNetTurnoutMessagesFlag());
        this.locoNetOccupancyMessagesCheckBox.setSelected(this.cs.getLocoNetOccupancyMessagesFlag());
    }
}

