/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21.simulator;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import jmri.JmriException;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.roco.z21.Z21Adapter;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21TrafficController;
import jmri.jmrix.roco.z21.simulator.Z21XNetSimulatorAdapter;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21SimulatorAdapter
extends Z21Adapter
implements Runnable {
    private Thread sourceThread;
    private Z21XNetSimulatorAdapter xnetadapter;
    private int[] flags = new int[4];
    volatile boolean threadStopRequest;
    volatile DatagramSocket socket;
    private static final Logger log = LoggerFactory.getLogger(Z21SimulatorAdapter.class);

    public Z21SimulatorAdapter() {
        this.setHostName("localhost");
        this.xnetadapter = new Z21XNetSimulatorAdapter();
    }

    @Override
    public void configure() {
        log.debug("configure called");
        Z21TrafficController packets = new Z21TrafficController();
        packets.connectPort(this);
        this.getSystemConnectionMemo().setTrafficController(packets);
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Z21SimulatorAdapter sourceThread");
        this.sourceThread.start();
        this.getSystemConnectionMemo().configureManagers();
    }

    @Override
    public void connect() throws IOException {
        log.debug("connect called");
        this.setHostAddress("localhost");
        super.connect();
    }

    public void terminateThread() {
        this.threadStopRequest = true;
        if (this.sourceThread != null) {
            this.sourceThread.interrupt();
            try {
                this.sourceThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.socket != null) {
            this.socket.close();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int retryCount = 0;
        block19: while (retryCount < 3) {
            if (this.threadStopRequest) {
                return;
            }
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try {
                    block27: {
                        DatagramPacket receivePacket;
                        DatagramSocket s = new DatagramSocket(COMMUNICATION_UDP_PORT);
                        this.socket = s;
                        s.setSoTimeout(100);
                        log.debug("socket created, starting loop");
                        finally {
                            if (this.threadStopRequest) continue;
                        }
                        log.debug("simulation loop");
                        byte[] input = new byte[100];
                        try {
                            receivePacket = new DatagramPacket(input, 100);
                            s.receive(receivePacket);
                            if (this.threadStopRequest) {
                                return;
                            }
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                        }
                        catch (IOException ex3) {
                            if (this.threadStopRequest) {
                                if (s == null) return;
                                s.close();
                                return;
                            }
                            log.error("IO Exception", (Throwable)ex3);
                            break block27;
                        }
                        {
                            Z21Reply reply;
                            int port;
                            InetAddress IPAddress;
                            Z21Message msg = new Z21Message(receivePacket.getLength());
                            int i = 0;
                            while (true) {
                                if (i >= receivePacket.getLength()) {
                                    IPAddress = receivePacket.getAddress();
                                    port = receivePacket.getPort();
                                    log.debug("Received packet: {}, message: {}", (Object)receivePacket.getData(), (Object)msg);
                                    try {
                                        reply = this.generateReply(msg);
                                        break;
                                    }
                                    catch (LogoffException logoffException) {
                                        log.debug("error generated by generateReply, exiting simulation");
                                        continue block19;
                                    }
                                }
                                msg.setElement(i, receivePacket.getData()[i]);
                                ++i;
                            }
                            if (reply == null) break block27;
                            byte[] ba = StringUtil.bytesFromHexString(reply.toString());
                            DatagramPacket sendPacket = new DatagramPacket(ba, ba.length, IPAddress, port);
                            s.send(sendPacket);
                        }
                    }
                    log.debug("Client Disconnect");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (BindException bex) {
                if (++retryCount > 2) {
                    log.error("Giving up after {} attempts.  Exception binding to port {}", new Object[]{retryCount, COMMUNICATION_UDP_PORT, bex});
                    return;
                }
                log.info("Attempt {}: Exception binding to port {}", (Object)retryCount, (Object)COMMUNICATION_UDP_PORT);
                try {
                    Thread.sleep((long)retryCount * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return;
        {
            catch (SocketException ex0) {
                log.error("Exception opening socket", (Throwable)ex0);
                return;
            }
            catch (RuntimeException rte) {
                log.error("Exception performing operation on socket", (Throwable)rte);
                return;
            }
        }
    }

    private Z21Reply generateReply(Z21Message m) throws LogoffException {
        Z21Reply reply;
        log.debug("generate Reply called with message {}", (Object)m);
        switch (m.getOpCode()) {
            case 16: {
                reply = this.getZ21SerialNumberReply();
                break;
            }
            case 26: {
                reply = this.getHardwareVersionReply();
                break;
            }
            case 64: {
                XNetMessage xnm = this.getXNetMessage(m);
                log.debug("Received XNet Message: {}", (Object)m);
                XNetReply xnr = this.xnetadapter.generateReply(xnm);
                reply = this.getZ21ReplyFromXNet(xnr);
                break;
            }
            case 48: {
                throw new LogoffException();
            }
            case 80: {
                this.flags[0] = m.getElement(4) & 0xFF;
                this.flags[1] = m.getElement(5) & 0xFF;
                this.flags[2] = m.getElement(6) & 0xFF;
                this.flags[3] = m.getElement(7) & 0xFF;
                reply = null;
                break;
            }
            case 81: {
                reply = this.getZ21BroadCastFlagsReply();
                break;
            }
            case 137: {
                reply = this.getZ21RailComDataChangedReply();
                break;
            }
            case 162: {
                reply = null;
                break;
            }
            case 163: {
                reply = this.getLocoNetDispatchReply(m);
                break;
            }
            case 164: {
                reply = this.getLocoNetDetectorStatusReply(m);
                break;
            }
            default: {
                reply = this.getXPressNetUnknownCommandReply();
            }
        }
        return reply;
    }

    private Z21Reply getHardwareVersionReply() {
        Z21Reply reply = new Z21Reply();
        reply.setLength(12);
        reply.setOpCode(26);
        reply.setElement(4, 0);
        reply.setElement(5, 2);
        reply.setElement(6, 0);
        reply.setElement(7, 0);
        reply.setElement(8, 32);
        reply.setElement(9, 1);
        reply.setElement(10, 0);
        reply.setElement(11, 0);
        return reply;
    }

    private Z21Reply getXPressNetUnknownCommandReply() {
        Z21Reply reply = new Z21Reply();
        reply.setLength(7);
        reply.setOpCode(64);
        reply.setElement(4, 97);
        reply.setElement(5, 130);
        reply.setElement(6, 227);
        return reply;
    }

    private Z21Reply getZ21SerialNumberReply() {
        Z21Reply reply = new Z21Reply();
        reply.setLength(8);
        reply.setOpCode(16);
        reply.setElement(4, 0);
        reply.setElement(5, 0);
        reply.setElement(6, 0);
        reply.setElement(7, 0);
        return reply;
    }

    private Z21Reply getZ21BroadCastFlagsReply() {
        Z21Reply reply = new Z21Reply();
        reply.setLength(8);
        reply.setOpCode(81);
        reply.setElement(4, this.flags[0]);
        reply.setElement(5, this.flags[1]);
        reply.setElement(6, this.flags[2]);
        reply.setElement(7, this.flags[3]);
        return reply;
    }

    private Z21Reply getZ21RailComDataChangedReply() {
        Z21Reply reply = new Z21Reply();
        reply.setOpCode(136);
        reply.setLength(4);
        int offset = 4;
        int i = 0;
        while (i < this.xnetadapter.locoCount) {
            reply.setElement(offset++, this.xnetadapter.locoData[i].getAddressLsb());
            reply.setElement(offset++, this.xnetadapter.locoData[i].getAddressMsb());
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 1);
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 0);
            reply.setElement(offset++, this.xnetadapter.locoData[i].getSpeed());
            reply.setElement(offset++, 0);
            reply.setElement(offset++, 0);
            reply.setLength(0xFFFF & offset);
            ++i;
        }
        log.debug("output {} offset: {}", (Object)reply.toString(), (Object)offset);
        return reply;
    }

    private XNetMessage getXNetMessage(Z21Message m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        XNetMessage xnm = new XNetMessage(m.getLength() - 4);
        int i = 4;
        while (i < m.getLength()) {
            xnm.setElement(i - 4, m.getElement(i));
            ++i;
        }
        return xnm;
    }

    private Z21Reply getZ21ReplyFromXNet(XNetReply m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        Z21Reply r = new Z21Reply();
        r.setLength(m.getNumDataElements() + 4);
        r.setOpCode(64);
        int i = 0;
        while (i < m.getNumDataElements()) {
            r.setElement(i + 4, m.getElement(i));
            ++i;
        }
        return r;
    }

    private Z21Reply getLocoNetDispatchReply(Z21Message m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        Z21Reply r = new Z21Reply();
        r.setLength(m.getNumDataElements() + 5);
        r.setOpCode(m.getOpCode());
        int i = 0;
        while (i < m.getNumDataElements()) {
            r.setElement(i + 4, m.getElement(i));
            ++i;
        }
        r.setElement(i + 4, 0);
        return r;
    }

    private Z21Reply getLocoNetDetectorStatusReply(Z21Message m) {
        if (m == null) {
            throw new IllegalArgumentException();
        }
        Z21Reply r = new Z21Reply();
        r.setLength(m.getNumDataElements() + 5);
        r.setOpCode(m.getOpCode());
        int i = 0;
        while (i < m.getNumDataElements()) {
            r.setElement(i + 4, m.getElement(i));
            ++i;
        }
        r.setElement(i + 4, 0);
        return r;
    }

    static class LogoffException
    extends JmriException {
        LogoffException() {
        }
    }
}

