/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.Turnout;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTurnoutManager;
import jmri.jmrix.roco.z21.Z21XNetTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetTurnoutManager
extends XNetTurnoutManager {
    private static final Logger log = LoggerFactory.getLogger(Z21XNetTurnoutManager.class);

    public Z21XNetTurnoutManager(XNetSystemConnectionMemo memo) {
        super(memo);
    }

    @Override
    @Nonnull
    protected Turnout createNewTurnout(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        int addr;
        try {
            addr = Integer.parseInt(systemName.substring(this.getSystemPrefix().length() + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to convert systemName '" + systemName + "' to a numeric Turnout address");
        }
        Z21XNetTurnout t = new Z21XNetTurnout(this.getSystemPrefix(), addr, this.tc);
        t.setUserName(userName);
        return t;
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    public void message(XNetReply l) {
        log.debug("received message: {}", (Object)l);
        if (l.getElement(0) == 67) {
            int address = (l.getElement(1) << 8) + l.getElement(2);
            log.debug("message has address: {}", (Object)(++address));
            String s = String.valueOf(this.getSystemNamePrefix()) + address;
            this.forwardMessageToTurnout(s, l);
        } else {
            super.message(l);
        }
    }

    @Override
    protected void forwardMessageToTurnout(String s, XNetReply l) {
        Z21XNetTurnout t = (Z21XNetTurnout)this.getBySystemName(s);
        if (t == null) {
            ((Z21XNetTurnout)this.provideTurnout(s)).initMessageZ21(l);
        } else {
            t.message(l);
        }
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String systemName, @Nonnull Locale locale) {
        return this.validateSystemNameFormatOnlyNumeric(systemName, locale);
    }
}

