/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.lenz.XNetTurnout;
import jmri.jmrix.roco.z21.Z21XNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetTurnout
extends XNetTurnout {
    private static final Logger log = LoggerFactory.getLogger(Z21XNetTurnout.class);

    public Z21XNetTurnout(String prefix, int pNumber, XNetTrafficController controller) {
        super(prefix, pNumber, controller);
    }

    @Override
    protected synchronized void forwardCommandChangeToLayout(int s) {
        if (s != this._mClosed && s != this._mThrown) {
            log.warn("Turnout {}: state {} not forwarded to layout.", (Object)this.mNumber, (Object)s);
            return;
        }
        log.debug("Turnout {}: forwarding state  {} to layout.", (Object)this.mNumber, (Object)s);
        Z21XNetMessage msg = Z21XNetMessage.getZ21SetTurnoutRequestMessage(this.mNumber, (s & this._mThrown) != 0, true, false);
        if (this.getFeedbackMode() == 64) {
            msg.setTimeout(0);
            this.tc.sendXNetMessage(msg, null);
            this.sendOffMessage(s);
        } else {
            this.queueMessage(msg, 2, this);
        }
    }

    @Override
    public void requestUpdateFromLayout() {
        log.debug("Turnout {} requesting update from layout", (Object)this.mNumber);
        super.requestUpdateFromLayout();
        Z21XNetMessage msg = Z21XNetMessage.getZ21TurnoutInfoRequestMessage(this.mNumber);
        msg.setBroadcastReply();
        this.queueMessage(msg, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notifyTimeout(XNetMessage msg) {
        log.debug("Notified of timeout on message {}", (Object)msg);
        Z21XNetTurnout z21XNetTurnout = this;
        synchronized (z21XNetTurnout) {
            if (this.internalState == 1) {
                this.sendOffMessage(this.getCommandedState());
            }
        }
    }

    synchronized void initMessageZ21(XNetReply l) {
        int oldState = this.internalState;
        this.message(l);
        this.internalState = oldState;
    }

    @Override
    public synchronized void message(XNetReply l) {
        log.debug("received message: {}", (Object)l);
        if (l.getElement(0) == 67) {
            int address = (l.getElement(1) << 8) + l.getElement(2);
            ++address;
            if (log.isDebugEnabled()) {
                log.debug("message has address: {}", (Object)address);
            }
            if (this.mNumber == address) {
                int messageState = this.decodeZ21FeedbackMessageState(l);
                if (this.getFeedbackMode() == 8) {
                    this.newKnownState(messageState);
                } else if (this.getFeedbackMode() == 1) {
                    this.newKnownState(this.getCommandedState());
                }
                if (this.internalState == 2) {
                    this.sendOffMessage(messageState);
                    this.sendQueuedMessage();
                }
            }
        } else {
            super.message(l);
        }
    }

    private int decodeZ21FeedbackMessageState(XNetReply l) {
        int state;
        switch (l.getElement(3)) {
            case 3: {
                state = 8;
                break;
            }
            case 2: {
                state = this._inverted ? 2 : 4;
                break;
            }
            case 1: {
                state = this._inverted ? 4 : 2;
                break;
            }
            default: {
                state = 1;
            }
        }
        return state;
    }

    @Override
    protected synchronized void sendOffMessage() {
        this.sendOffMessage(this.getCommandedState());
    }

    protected synchronized void sendOffMessage(int state) {
        if (log.isDebugEnabled()) {
            log.debug("Sending off message for turnout {} commanded state={}", (Object)this.mNumber, (Object)this.getCommandedState());
            log.debug("Current Thread ID: {} Thread Name {}", (Object)Thread.currentThread().getId(), (Object)Thread.currentThread().getName());
        }
        XNetMessage msg = this.getOffMessage(state == this._mThrown);
        this.newKnownState(this.getCommandedState());
        this.internalState = 0;
        this.tc.sendXNetMessage(msg, this);
    }

    protected synchronized XNetMessage getOffMessage(boolean state) {
        Z21XNetMessage msg = Z21XNetMessage.getZ21SetTurnoutRequestMessage(this.mNumber, state, false, false);
        msg.setBroadcastReply();
        return msg;
    }
}

