/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.LocoAddress;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetSystemConnectionMemo;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.roco.RocoXNetThrottle;
import jmri.jmrix.roco.z21.Z21XNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetThrottle
extends RocoXNetThrottle {
    private static final Logger log = LoggerFactory.getLogger(Z21XNetThrottle.class);

    public Z21XNetThrottle(XNetSystemConnectionMemo memo, XNetTrafficController controller) {
        super(memo, controller);
    }

    public Z21XNetThrottle(XNetSystemConnectionMemo memo, LocoAddress address, XNetTrafficController controller) {
        super(memo, address, controller);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setSpeedSetting(float speed) {
        log.debug("set Speed to: {} Current step mode is: {}", (Object)Float.valueOf(speed), (Object)this.speedStepMode);
        Z21XNetThrottle z21XNetThrottle = this;
        synchronized (z21XNetThrottle) {
            this.speedSetting = speed;
        }
        this.record(speed);
        if (speed < 0.0f) {
            this.sendEmergencyStop();
        } else {
            if (speed > 1.0f) {
                speed = 1.0f;
            }
            XNetMessage msg = Z21XNetMessage.getZ21LanXSetLocoDriveMsg(this.getDccAddress(), this.speedStepMode, speed, this.isForward);
            this.queueMessage(msg, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSpeedSetting(float speed, boolean allowDuplicates, boolean allowDuplicatesOnStop) {
        Z21XNetThrottle z21XNetThrottle = this;
        synchronized (z21XNetThrottle) {
            this.speedSetting = speed;
        }
        this.record(speed);
    }

    @Override
    protected synchronized void sendStatusInformationRequest() {
        Z21XNetMessage msg = Z21XNetMessage.getZ21LocomotiveInfoRequestMsg(this.address);
        msg.setRetries(1);
        this.queueMessage(msg, 1);
    }

    @Override
    protected void sendFunctionGroup1() {
        Z21XNetMessage msg = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 0, this.getFunction(0));
        this.queueMessage(msg, 0);
        Z21XNetMessage msg1 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 1, this.getFunction(1));
        this.queueMessage(msg1, 0);
        Z21XNetMessage msg2 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 2, this.getFunction(2));
        this.queueMessage(msg2, 0);
        Z21XNetMessage msg3 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 3, this.getFunction(3));
        this.queueMessage(msg3, 0);
        Z21XNetMessage msg4 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 4, this.getFunction(4));
        this.queueMessage(msg4, 0);
    }

    @Override
    protected void sendFunctionGroup2() {
        Z21XNetMessage msg = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 5, this.getFunction(5));
        this.queueMessage(msg, 0);
        Z21XNetMessage msg1 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 6, this.getFunction(6));
        this.queueMessage(msg1, 0);
        Z21XNetMessage msg2 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 7, this.getFunction(7));
        this.queueMessage(msg2, 0);
        Z21XNetMessage msg3 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 8, this.getFunction(8));
        this.queueMessage(msg3, 0);
    }

    @Override
    protected void sendFunctionGroup3() {
        Z21XNetMessage msg = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 9, this.getFunction(9));
        this.queueMessage(msg, 0);
        Z21XNetMessage msg1 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 10, this.getFunction(10));
        this.queueMessage(msg1, 0);
        Z21XNetMessage msg2 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 11, this.getFunction(11));
        this.queueMessage(msg2, 0);
        Z21XNetMessage msg3 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 12, this.getFunction(12));
        this.queueMessage(msg3, 0);
    }

    @Override
    protected void sendFunctionGroup4() {
        Z21XNetMessage msg = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 13, this.getFunction(13));
        this.queueMessage(msg, 0);
        Z21XNetMessage msg1 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 14, this.getFunction(14));
        this.queueMessage(msg1, 0);
        Z21XNetMessage msg2 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 15, this.getFunction(15));
        this.queueMessage(msg2, 0);
        Z21XNetMessage msg3 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 16, this.getFunction(16));
        this.queueMessage(msg3, 0);
        Z21XNetMessage msg4 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 17, this.getFunction(17));
        this.queueMessage(msg4, 0);
        Z21XNetMessage msg5 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 18, this.getFunction(18));
        this.queueMessage(msg5, 0);
        Z21XNetMessage msg6 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 19, this.getFunction(19));
        this.queueMessage(msg6, 0);
        Z21XNetMessage msg7 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 20, this.getFunction(20));
        this.queueMessage(msg7, 0);
    }

    @Override
    protected void sendFunctionGroup5() {
        Z21XNetMessage msg = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 21, this.getFunction(21));
        this.queueMessage(msg, 0);
        Z21XNetMessage msg1 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 22, this.getFunction(22));
        this.queueMessage(msg1, 0);
        Z21XNetMessage msg2 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 23, this.getFunction(23));
        this.queueMessage(msg2, 0);
        Z21XNetMessage msg3 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 24, this.getFunction(24));
        this.queueMessage(msg3, 0);
        Z21XNetMessage msg4 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 25, this.getFunction(25));
        this.queueMessage(msg4, 0);
        Z21XNetMessage msg5 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 26, this.getFunction(26));
        this.queueMessage(msg5, 0);
        Z21XNetMessage msg6 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 27, this.getFunction(27));
        this.queueMessage(msg6, 0);
        Z21XNetMessage msg7 = Z21XNetMessage.getZ21LocomotiveFunctionOperationMsg(this.getDccAddress(), 28, this.getFunction(28));
        this.queueMessage(msg7, 0);
    }

    @Override
    protected void sendEmergencyStop() {
        this.setSpeedSetting(0.0f);
    }

    @Override
    public void message(XNetReply l) {
        log.debug("Throttle {} - received message {}", (Object)this.getDccAddress(), (Object)l.toString());
        if ((l.getElement(0) & 0xE0) == 224 && (l.getElement(0) & 0xF) >= 7 && (l.getElement(0) & 0xF) <= 15) {
            int messageaddress = ((l.getElement(1) & 0x3F) << 8) + l.getElement(2);
            if (messageaddress == this.getDccAddress()) {
                int b2 = l.getElement(3) & 0xFF;
                int b3 = l.getElement(4) & 0xFF;
                int b4 = l.getElement(5) & 0xFF;
                int b5 = l.getElement(6) & 0xFF;
                int b6 = l.getElement(7) & 0xFF;
                int b7 = l.getElement(8) & 0xFF;
                this.parseSpeedAndAvailability(b2);
                this.parseSpeedAndDirection(b3);
                this.parseFunctionInformation(b4, b5);
                this.parseFunctionHighInformation(b6, b7);
                this.requestState = 0;
                this.sendQueuedMessage();
            }
        } else {
            super.message(l);
        }
    }

    @Override
    public void throttleDispose() {
        this.active = false;
        this.stopStatusTimer();
        this.finishRecord();
    }
}

