/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.roco.z21.Bundle;
import jmri.jmrix.roco.z21.Z21XNetMessage;

public class Z21XNetReply
extends XNetReply {
    public Z21XNetReply() {
    }

    public Z21XNetReply(Z21XNetReply reply) {
        super(reply);
    }

    public Z21XNetReply(Z21XNetMessage message) {
        super(message);
    }

    public Z21XNetReply(String message) {
        super(message);
    }

    @Override
    public boolean isServiceModeResponse() {
        return this.getElement(0) == 100 && this.getElement(1) == 20 || super.isServiceModeResponse();
    }

    @Override
    public boolean isFeedbackMessage() {
        return this.getElement(0) == 67 || super.isFeedbackMessage();
    }

    @Override
    public String toMonitorString() {
        String text;
        if (this.getElement(0) == 100) {
            if (this.getElement(1) == 20) {
                int value = this.getElement(4) & 0xFF;
                int cv = ((this.getElement(2) & 0xFF) << 8) + (this.getElement(3) & 0xFF) + 1;
                text = Bundle.getMessage("Z21LAN_X_CV_RESULT", cv, value);
            } else {
                text = super.toMonitorString();
            }
        } else if ((this.getElement(0) & 0xE0) == 224 && (this.getElement(0) & 0xF) >= 7 && (this.getElement(0) & 0xF) <= 15) {
            int messageaddress = ((this.getElement(1) & 0x3F) << 8) + (this.getElement(2) & 0xFF);
            text = "Z21 Mobile decoder info reply for address " + messageaddress + ":";
            int b2 = this.getElement(3) & 0xFF;
            int b3 = this.getElement(4) & 0xFF;
            int b4 = this.getElement(5) & 0xFF;
            int b5 = this.getElement(6) & 0xFF;
            int b6 = this.getElement(7) & 0xFF;
            int b7 = this.getElement(8) & 0xFF;
            text = String.valueOf(text) + " " + this.parseSpeedAndDirection(b2, b3);
            text = String.valueOf(text) + " " + this.parseFunctionStatus(b4, b5);
            text = String.valueOf(text) + " " + this.parseFunctionHighStatus(b6, b7);
        } else if (this.getElement(0) == 67) {
            int address = (this.getElement(1) << 8) + this.getElement(2) + 1;
            String state = "";
            switch (this.getElement(3)) {
                case 3: {
                    state = String.valueOf(state) + "inconsistent";
                    break;
                }
                case 2: {
                    state = String.valueOf(state) + "Thrown";
                    break;
                }
                case 1: {
                    state = String.valueOf(state) + "Closed";
                    break;
                }
                default: {
                    state = String.valueOf(state) + "Unknown";
                }
            }
            text = Bundle.getMessage("Z21LAN_X_TURNOUT_INFO", address, state);
        } else {
            text = super.toMonitorString();
        }
        return text;
    }
}

