/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.lenz.XNetProgrammer;
import jmri.jmrix.lenz.XNetReply;
import jmri.jmrix.lenz.XNetTrafficController;
import jmri.jmrix.roco.z21.Z21XNetMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21XNetProgrammer
extends XNetProgrammer {
    private static final Logger log = LoggerFactory.getLogger(Z21XNetProgrammer.class);

    public Z21XNetProgrammer(XNetTrafficController tc) {
        super(tc);
        this.controller().addXNetListener(-1, this);
    }

    @Override
    public boolean getCanRead(String addr) {
        if (log.isDebugEnabled()) {
            log.debug("check mode {} CV {}", (Object)this.getMode(), (Object)addr);
        }
        if (!this.getCanRead()) {
            return false;
        }
        if (this.controller().getCommandStation().getCommandStationType() == 16) {
            return false;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            return true;
        }
        return Integer.parseInt(addr) <= 256;
    }

    @Override
    public boolean getCanWrite(String addr) {
        if (log.isDebugEnabled()) {
            log.debug("check CV {}", (Object)addr);
            log.debug("cs Type: {} CS Version: {}", (Object)this.controller().getCommandStation().getCommandStationType(), (Object)Float.valueOf(this.controller().getCommandStation().getCommandStationSoftwareVersion()));
        }
        if (!this.getCanWrite()) {
            return false;
        }
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            return true;
        }
        return Integer.parseInt(addr) <= 256;
    }

    @Override
    public synchronized void writeCV(String CVname, int val, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            if (log.isDebugEnabled()) {
                log.debug("writeCV {} listens {}", (Object)CV, (Object)p);
            }
            this.useProgrammer(p);
            this._progRead = false;
            this.progState = 1;
            this._val = val;
            this._cv = 0xFFFF & CV;
            this.restartTimer(90000);
            Z21XNetMessage msg = Z21XNetMessage.getZ21WriteDirectCVMsg(CV, val);
            this.controller().sendXNetMessage(msg, this);
        } else {
            super.writeCV(CVname, val, p);
        }
    }

    @Override
    public synchronized void readCV(String CVname, ProgListener p) throws ProgrammerException {
        int CV = Integer.parseInt(CVname);
        if (this.getMode().equals(ProgrammingMode.DIRECTBITMODE) || this.getMode().equals(ProgrammingMode.DIRECTBYTEMODE)) {
            if (log.isDebugEnabled()) {
                log.debug("readCV {} listens {}", (Object)CV, (Object)p);
            }
            this.useProgrammer(p);
            this._cv = 0xFFFF & CV;
            this._progRead = true;
            this.progState = 1;
            this.restartTimer(90000);
            Z21XNetMessage msg = Z21XNetMessage.getZ21ReadDirectCVMsg(CV);
            this.controller().sendXNetMessage(msg, this);
        } else {
            super.readCV(CVname, p);
        }
    }

    @Override
    public synchronized void message(XNetReply m) {
        if (this.progState != 0) {
            if (this.progState == 1 || this.progState == 2) {
                if (log.isDebugEnabled()) {
                    log.debug("reply in {} state", (Object)(this.progState == 1 ? "REQUESTSENT" : "INQUIRESENT"));
                }
                if (m.getElement(0) == 100 && m.getElement(1) == 20) {
                    int sent_cv = (m.getElement(2) << 8) + m.getElement(3) + 1;
                    if (sent_cv != this._cv) {
                        return;
                    }
                    if (this._progRead) {
                        this._val = m.getElement(4);
                    }
                    this.progState = 0;
                    this.stopTimer();
                    this.notifyProgListenerEnd(this._val, 0);
                } else {
                    super.message(m);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("reply in un-decoded state");
            }
        }
    }
}

