/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.jmrix.ConfiguringSystemConnectionMemo;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.lenz.XNetProgrammerManager;
import jmri.jmrix.roco.z21.RocoZ21CommandStation;
import jmri.jmrix.roco.z21.Z21HeartBeat;
import jmri.jmrix.roco.z21.Z21LocoNetTunnel;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21PredefinedMeters;
import jmri.jmrix.roco.z21.Z21ReporterManager;
import jmri.jmrix.roco.z21.Z21SensorManager;
import jmri.jmrix.roco.z21.Z21TrafficController;
import jmri.jmrix.roco.z21.Z21XNetProgrammerManager;
import jmri.jmrix.roco.z21.Z21XPressNetTunnel;
import jmri.jmrix.roco.z21.swing.Z21ComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.managers.AbstractMeterManager;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21SystemConnectionMemo
extends DefaultSystemConnectionMemo
implements ConfiguringSystemConnectionMemo {
    private Z21XPressNetTunnel _xnettunnel = null;
    private Z21LocoNetTunnel _loconettunnel = null;
    ComponentFactory componentFactory = null;
    private Z21TrafficController _tc = null;
    protected Z21PredefinedMeters predefinedMeters;
    private Z21HeartBeat heartBeat = null;
    private static final Logger log = LoggerFactory.getLogger(Z21SystemConnectionMemo.class);

    public Z21SystemConnectionMemo() {
        this("Z", "Z21");
    }

    public Z21SystemConnectionMemo(String prefix, String userName) {
        super(prefix, userName);
        InstanceManager.store(this, Z21SystemConnectionMemo.class);
        this.init();
    }

    protected void init() {
        this.componentFactory = new Z21ComponentFactory(this);
        InstanceManager.store(this.componentFactory, ComponentFactory.class);
    }

    public void setTrafficController(Z21TrafficController newtc) {
        this._tc = newtc;
    }

    public Z21TrafficController getTrafficController() {
        return this._tc;
    }

    public void setReporterManager(Z21ReporterManager rm) {
        this.store(rm, ReporterManager.class);
    }

    public Z21ReporterManager getReporterManager() {
        return (Z21ReporterManager)this.classObjectMap.computeIfAbsent(ReporterManager.class, c -> new Z21ReporterManager(this));
    }

    public void setSensorManager(Z21SensorManager sm) {
        this.store(sm, SensorManager.class);
    }

    public Z21SensorManager getSensorManager() {
        return (Z21SensorManager)this.classObjectMap.computeIfAbsent(SensorManager.class, c -> new Z21SensorManager(this));
    }

    public XNetProgrammerManager getProgrammerManager() {
        if (this._xnettunnel != null) {
            return this._xnettunnel.getStreamPortController().getSystemConnectionMemo().getProgrammerManager();
        }
        return null;
    }

    public void setProgrammerManager(XNetProgrammerManager p) {
    }

    @Override
    public boolean provides(Class<?> type) {
        if (this.getDisabled()) {
            return false;
        }
        if (type.equals(ReporterManager.class)) {
            return true;
        }
        if (type.equals(SensorManager.class)) {
            return true;
        }
        if (this._xnettunnel != null && this._xnettunnel.getStreamPortController().getSystemConnectionMemo().provides(type)) {
            return true;
        }
        if (this._loconettunnel != null && this._loconettunnel.getStreamPortController().getSystemConnectionMemo().provides(type)) {
            return true;
        }
        return super.provides(type);
    }

    @Override
    public <T> T get(Class<?> T) {
        if (this.getDisabled()) {
            return null;
        }
        if (T.equals(ReporterManager.class)) {
            return super.get(T);
        }
        if (T.equals(SensorManager.class)) {
            return super.get(T);
        }
        if (this._xnettunnel != null && this._xnettunnel.getStreamPortController().getSystemConnectionMemo().provides(T)) {
            return this._xnettunnel.getStreamPortController().getSystemConnectionMemo().get(T);
        }
        if (this._loconettunnel != null && this._loconettunnel.getStreamPortController().getSystemConnectionMemo().provides(T)) {
            return this._loconettunnel.getStreamPortController().getSystemConnectionMemo().get(T);
        }
        return null;
    }

    @Override
    public void configureManagers() {
        log.debug("Called Configure Managers");
        RocoZ21CommandStation z21CommandStation = this.getRocoZ21CommandStation();
        z21CommandStation.setXPressNetMessagesFlag(true);
        z21CommandStation.setXPressNetLocomotiveMessagesFlag(true);
        z21CommandStation.setLocoNetMessagesFlag(true);
        z21CommandStation.setLocoNetLocomotiveMessagesFlag(true);
        z21CommandStation.setLocoNetTurnoutMessagesFlag(true);
        this._tc.sendz21Message(Z21Message.getLanSetBroadcastFlagsRequestMessage(z21CommandStation.getZ21BroadcastFlags()), null);
        this._loconettunnel = (Z21LocoNetTunnel)this.classObjectMap.computeIfAbsent(Z21LocoNetTunnel.class, c -> new Z21LocoNetTunnel(this));
        this._xnettunnel = (Z21XPressNetTunnel)this.classObjectMap.computeIfAbsent(Z21XPressNetTunnel.class, c -> new Z21XPressNetTunnel(this));
        InstanceManager.setReporterManager(this.getReporterManager());
        InstanceManager.setSensorManager(this.getSensorManager());
        XNetProgrammerManager xpm = this._xnettunnel.getStreamPortController().getSystemConnectionMemo().getProgrammerManager();
        if (xpm instanceof Z21XNetProgrammerManager) {
            ((Z21XNetProgrammerManager)xpm).setLocoNetMemo(this._loconettunnel.getStreamPortController().getSystemConnectionMemo());
        }
        this.createPredefinedMeters();
        this.getHeartBeat();
        this.register();
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.roco.z21.z21ActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    public CommandStation getCommandStation() {
        return (CommandStation)this.get(CommandStation.class);
    }

    public void setCommandStation(CommandStation c) {
        this.store(c, CommandStation.class);
    }

    public RocoZ21CommandStation getRocoZ21CommandStation() {
        return (RocoZ21CommandStation)this.classObjectMap.computeIfAbsent(RocoZ21CommandStation.class, c -> new RocoZ21CommandStation());
    }

    public void setRocoZ21CommandStation(RocoZ21CommandStation c) {
        this.store(c, RocoZ21CommandStation.class);
    }

    public Z21PredefinedMeters createPredefinedMeters() {
        if (this.getDisabled()) {
            return null;
        }
        if (this.predefinedMeters == null) {
            InstanceManager.setMeterManager(new AbstractMeterManager(this));
            this.predefinedMeters = new Z21PredefinedMeters(this);
        }
        return this.predefinedMeters;
    }

    public Z21HeartBeat getHeartBeat() {
        if (this.heartBeat == null) {
            this.heartBeat = new Z21HeartBeat(this);
        }
        return this.heartBeat;
    }

    void shutdownTunnel() {
        if (this._xnettunnel != null) {
            this._xnettunnel.dispose();
            this._xnettunnel = null;
        }
    }

    @Override
    public void dispose() {
        if (this.heartBeat != null) {
            this.heartBeat.dispose();
        }
        this.shutdownTunnel();
        InstanceManager.deregister(this, Z21SystemConnectionMemo.class);
        if (this.predefinedMeters != null) {
            this.predefinedMeters.dispose();
        }
        super.dispose();
    }
}

