/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.Manager;
import jmri.Sensor;
import jmri.jmrix.roco.z21.Bundle;
import jmri.jmrix.roco.z21.Z21CanBusAddress;
import jmri.jmrix.roco.z21.Z21CanSensor;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21RMBusAddress;
import jmri.jmrix.roco.z21.Z21RMBusSensor;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21SystemNameComparator;
import jmri.managers.AbstractSensorManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21SensorManager
extends AbstractSensorManager
implements Z21Listener {
    int iName;
    private static final Logger log = LoggerFactory.getLogger(Z21SensorManager.class);

    public Z21SensorManager(Z21SystemConnectionMemo memo) {
        super(memo);
        memo.getTrafficController().addz21Listener(this);
        memo.getRocoZ21CommandStation().setCanDetectorFlag(true);
        memo.getRocoZ21CommandStation().setRMBusMessagesFlag(true);
        memo.getTrafficController().sendz21Message(Z21Message.getLanSetBroadcastFlagsRequestMessage(memo.getRocoZ21CommandStation().getZ21BroadcastFlags()), null);
    }

    @Override
    @Nonnull
    public Z21SystemConnectionMemo getMemo() {
        return (Z21SystemConnectionMemo)this.memo;
    }

    @Override
    public void dispose() {
        this.getMemo().getTrafficController().removez21Listener(this);
        super.dispose();
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        if (systemName.contains(":")) {
            int bitNum = Z21CanBusAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
            if (bitNum != -1) {
                return new Z21CanSensor(systemName, userName, this.getMemo());
            }
            throw new IllegalArgumentException("Invalid Sensor name: " + systemName);
        }
        int bitNum = Z21RMBusAddress.getBitFromSystemName(systemName, this.getSystemPrefix());
        if (bitNum != -1) {
            return new Z21RMBusSensor(systemName, userName, this.getMemo().getTrafficController(), this.getSystemPrefix());
        }
        throw new IllegalArgumentException("Invalid Sensor name: " + systemName);
    }

    @Override
    public void reply(Z21Reply msg) {
        log.debug("received message: {}", (Object)msg);
        if (msg.isCanDetectorMessage()) {
            int type = msg.getElement(9) & 0xFF;
            log.debug("Sensor message type {}", (Object)type);
            if (type == 1) {
                log.debug("Received LAN_CAN_DETECTOR message");
                int netID = (msg.getElement(4) & 0xFF) + ((msg.getElement(5) & 0xFF) << 8);
                int msgPort = msg.getElement(8) & 0xFF;
                int address = (msg.getElement(6) & 0xFF) + ((msg.getElement(7) & 0xFF) << 8);
                String systemName = Z21CanBusAddress.buildDecimalSystemNameFromParts(this.getSystemPrefix(), this.typeLetter(), address, msgPort);
                Z21CanSensor r = (Z21CanSensor)this.getBySystemName(systemName);
                if (r == null && (r = (Z21CanSensor)this.getBySystemName(systemName = Z21CanBusAddress.buildHexSystemNameFromParts(this.getSystemPrefix(), this.typeLetter(), netID, msgPort))) == null) {
                    log.debug("Creating reporter {}", (Object)systemName);
                    ((Z21CanSensor)this.provideSensor(systemName)).reply(msg);
                }
            }
        } else if (msg.isRMBusDataChangedReply()) {
            log.debug("Received RM Bus Data Changed message");
        }
    }

    @Override
    public void message(Z21Message l) {
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) {
        if ((name = this.validateSystemNamePrefix(name, locale)).substring(this.getSystemNamePrefix().length()).contains(":")) {
            return Z21CanBusAddress.validateSystemNameFormat(name, this, locale);
        }
        return Z21RMBusAddress.validateSystemNameFormat(name, this, locale);
    }

    @Override
    public Manager.NameValidity validSystemNameFormat(@Nonnull String systemName) {
        return Z21RMBusAddress.validSystemNameFormat(systemName, 'S', this.getSystemPrefix()) == Manager.NameValidity.VALID ? Manager.NameValidity.VALID : Z21CanBusAddress.validSystemNameFormat(systemName, 'S', this.getSystemPrefix());
    }

    @Override
    public boolean allowMultipleAdditions(@Nonnull String systemName) {
        return true;
    }

    @Override
    @Nonnull
    public synchronized String createSystemName(@Nonnull String curAddress, @Nonnull String prefix) throws JmriException {
        if (curAddress.contains(":")) {
            int seperator = curAddress.indexOf(58);
            try {
                int encoderAddress = Integer.parseInt(curAddress.substring(0, seperator));
                int input = Integer.parseInt(curAddress.substring(seperator + 1));
                return Z21CanBusAddress.buildDecimalSystemNameFromParts(this.getSystemPrefix(), this.typeLetter(), encoderAddress, input);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    int encoderAddress = Integer.parseInt(curAddress.substring(0, seperator), 16);
                    int input = Integer.parseInt(curAddress.substring(seperator + 1));
                    return Z21CanBusAddress.buildHexSystemNameFromParts(this.getSystemPrefix(), this.typeLetter(), encoderAddress, input);
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new JmriException("Unable to convert " + curAddress + " into the cab and input format of nn:xx");
                }
            }
        }
        try {
            this.iName = Integer.parseInt(curAddress);
            return String.valueOf(this.getSystemPrefix()) + this.typeLetter() + this.iName;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JmriException("Hardware Address " + curAddress + " passed should be a number or the cab and input format of nn:xx");
        }
    }

    @Override
    public synchronized String getNextValidAddress(@Nonnull String curAddress, @Nonnull String prefix, boolean ignoreInitialExisting) throws JmriException {
        String tmpSName = this.createSystemName(curAddress, prefix);
        Sensor s = this.getBySystemName(tmpSName);
        if (s != null || ignoreInitialExisting) {
            int x = 1;
            while (x < 10) {
                ++this.iName;
                s = this.getBySystemName(String.valueOf(prefix) + this.typeLetter() + this.iName);
                if (s == null) {
                    return Integer.toString(this.iName);
                }
                ++x;
            }
            log.warn(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, this.iName));
            throw new JmriException(Bundle.getMessage("InvalidNextValidTenInUse", this.getBeanTypeHandled(true), curAddress, this.iName));
        }
        return Integer.toString(this.iName);
    }

    @Override
    public Sensor getBySystemName(@Nonnull String sName) {
        Z21SystemNameComparator comparator = new Z21SystemNameComparator(this.getSystemPrefix(), this.typeLetter());
        return (Sensor)this.getBySystemName(sName, comparator);
    }

    @Override
    public String getEntryToolTip() {
        return Bundle.getMessage("AddInputEntryToolTip");
    }
}

