/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.DccLocoAddress;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.roco.z21.Bundle;
import jmri.jmrix.roco.z21.Z21MessageUtils;
import jmri.jmrix.roco.z21.Z21XNetReply;

public class Z21Reply
extends AbstractMRReply {
    private static final String WRONG_REPLY_TYPE = "Wrong Reply Type";

    public Z21Reply() {
        this.setBinary(true);
    }

    public Z21Reply(byte[] a, int l) {
        this._nDataChars = l;
        this.setBinary(true);
        int i = 0;
        while (i < this._nDataChars) {
            this._dataChars[i] = a[i];
            ++i;
        }
    }

    @Override
    public void setElement(int n, int v) {
        this._dataChars[n] = (char)v;
        this._nDataChars = Math.max(this._nDataChars, n + 1);
    }

    public Integer getElementBCD(int n) {
        return Integer.decode(Integer.toHexString(this.getElement(n)));
    }

    @Override
    public void setOpCode(int i) {
        this._dataChars[2] = (char)(i & 0xFF);
        this._dataChars[3] = (char)((i & 0xFF00) >> 8);
        this._nDataChars = Math.max(this._nDataChars, 4);
    }

    @Override
    public int getOpCode() {
        return (0xFF & this._dataChars[2]) + ((0xFF & this._dataChars[3]) << 8);
    }

    public void setLength(int i) {
        this._dataChars[0] = (char)(i & 0xFF);
        this._dataChars[1] = (char)((i & 0xFF00) >> 8);
        this._nDataChars = Math.max(this._nDataChars, i);
    }

    public int getLength() {
        return (0xFF & this._dataChars[0]) + ((0xFF & this._dataChars[1]) << 8);
    }

    @Override
    protected int skipPrefix(int index) {
        return 0;
    }

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public String toMonitorString() {
        switch (this.getOpCode()) {
            case 16: {
                int serialNo = (this.getElement(4) & 0xFF) + ((this.getElement(5) & 0xFF) << 8) + ((this.getElement(6) & 0xFF) << 16) + ((this.getElement(7) & 0xFF) << 24);
                return Bundle.getMessage("Z21ReplyStringSerialNo", serialNo);
            }
            case 26: {
                int hwversion = this.getElement(4) + (this.getElement(5) << 8) + (this.getElement(6) << 16) + (this.getElement(7) << 24);
                float swversion = (float)this.getElementBCD(8).intValue() / 100.0f + (float)this.getElementBCD(9).intValue() + (float)(this.getElementBCD(10) * 100) + (float)(this.getElementBCD(11) * 10000);
                return Bundle.getMessage("Z21ReplyStringVersion", Integer.toHexString(hwversion), Float.valueOf(swversion));
            }
            case 64: {
                return Bundle.getMessage("Z21XpressNetTunnelReply", this.getXNetReply().toMonitorString());
            }
            case 81: {
                return Bundle.getMessage("Z21ReplyBroadcastFlags", Z21MessageUtils.interpretBroadcastFlags(this._dataChars));
            }
            case 128: {
                int groupIndex = this.getElement(4) & 0xFF;
                int offset = groupIndex * 10 + 1;
                String[] moduleStatus = new String[10];
                int i = 0;
                while (i < 10) {
                    moduleStatus[i] = Bundle.getMessage("RMModuleFeedbackStatus", offset + i, Bundle.getMessage("RMModuleContactStatus", 1, (this.getElement(i + 5) & 1) == 1 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 2, (this.getElement(i + 5) & 2) == 2 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 3, (this.getElement(i + 5) & 4) == 4 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 4, (this.getElement(i + 5) & 8) == 8 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 5, (this.getElement(i + 5) & 0x10) == 16 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 6, (this.getElement(i + 5) & 0x20) == 32 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 7, (this.getElement(i + 5) & 0x40) == 64 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")), Bundle.getMessage("RMModuleContactStatus", 8, (this.getElement(i + 5) & 0x80) == 128 ? Bundle.getMessage("PowerStateOn") : Bundle.getMessage("PowerStateOff")));
                    ++i;
                }
                return Bundle.getMessage("RMBusFeedbackStatus", groupIndex, moduleStatus[0], moduleStatus[1], moduleStatus[2], moduleStatus[3], moduleStatus[4], moduleStatus[5], moduleStatus[6], moduleStatus[7], moduleStatus[8], moduleStatus[9]);
            }
            case 132: {
                int mainCurrent = this.getSystemDataMainCurrent();
                int progCurrent = this.getSystemDataProgCurrent();
                int filteredMainCurrent = this.getSystemDataFilteredMainCurrent();
                int temperature = this.getSystemDataTemperature();
                int supplyVolts = this.getSystemDataSupplyVoltage();
                int internalVolts = this.getSystemDataVCCVoltage();
                int state = this.getElement(16);
                int extendedState = this.getElement(17);
                return Bundle.getMessage("Z21SystemStateReply", mainCurrent, progCurrent, filteredMainCurrent, temperature, supplyVolts, internalVolts, state, extendedState);
            }
            case 160: {
                return Bundle.getMessage("Z21LocoNetRxReply", this.getLocoNetMessage().toMonitorString());
            }
            case 161: {
                return Bundle.getMessage("Z21LocoNetTxReply", this.getLocoNetMessage().toMonitorString());
            }
            case 162: {
                return Bundle.getMessage("Z21LocoNetLanReply", this.getLocoNetMessage().toMonitorString());
            }
            case 136: {
                int entries = this.getNumRailComDataEntries();
                StringBuilder datastring = new StringBuilder();
                int i = 0;
                while (i < entries) {
                    DccLocoAddress address = this.getRailComLocoAddress(i);
                    int rcvCount = this.getRailComRcvCount(i);
                    int errorCount = this.getRailComErrCount(i);
                    int speed = this.getRailComSpeed(i);
                    int options = this.getRailComOptions(i);
                    int qos = this.getRailComQos(i);
                    datastring.append(Bundle.getMessage("Z21_RAILCOM_DATA", address, rcvCount, errorCount, options, speed, qos));
                    datastring.append("\n");
                    ++i;
                }
                return Bundle.getMessage("Z21_RAILCOM_DATACHANGED", entries, new String(datastring));
            }
            case 196: {
                String value1String;
                int networkID = (this.getElement(4) & 0xFF) + ((this.getElement(5) & 0xFF) << 8);
                int address = (this.getElement(6) & 0xFF) + ((this.getElement(7) & 0xFF) << 8);
                int port = this.getElement(8) & 0xFF;
                int type = this.getElement(9) & 0xFF;
                int value1 = (this.getElement(10) & 0xFF) + ((this.getElement(11) & 0xFF) << 8);
                int value2 = (this.getElement(12) & 0xFF) + ((this.getElement(13) & 0xFF) << 8);
                String typeString = "";
                String value2String = "";
                block13 : switch (type) {
                    case 1: {
                        typeString = "Input Status";
                        switch (value1) {
                            case 0: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_FREE_WITHOUT");
                                break block13;
                            }
                            case 256: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_FREE_WITH");
                                break block13;
                            }
                            case 4096: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_BUSY_WITHOUT");
                                break block13;
                            }
                            case 4352: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_BUSY_WITH");
                                break block13;
                            }
                            case 4609: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_OVERLOAD_1");
                                break block13;
                            }
                            case 4610: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_OVERLOAD_2");
                                break block13;
                            }
                            case 4611: {
                                value1String = Bundle.getMessage("Z21_CAN_INPUT_STATUS_OVERLOAD_3");
                                break block13;
                            }
                        }
                        value1String = "<unknown>";
                        break;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        typeString = "Occupancy Info";
                        value1String = this.getCanDetectorLocoAddressString(value1);
                        value2String = this.getCanDetectorLocoAddressString(value2);
                        break;
                    }
                    default: {
                        value1String = "" + value1;
                        value2String = "" + value2;
                    }
                }
                return Bundle.getMessage("Z21CANDetectorReply", Integer.toHexString(networkID), address, port, typeString, value1String, value2String);
            }
        }
        return this.toString();
    }

    boolean isXPressNetTunnelMessage() {
        return this.getOpCode() == 64;
    }

    Z21XNetReply getXNetReply() {
        Z21XNetReply xnr = null;
        if (this.isXPressNetTunnelMessage()) {
            int i = 4;
            xnr = new Z21XNetReply();
            while (i < this.getLength()) {
                xnr.setElement(i - 4, this.getElement(i));
                ++i;
            }
            if ((xnr.getElement(0) & 0xF) > xnr.getNumDataElements() + 2) {
                i -= 4;
                while (i < (xnr.getElement(0) & 0xF) + 2) {
                    xnr.setElement(i, 0);
                    ++i;
                }
            }
        }
        return xnr;
    }

    boolean isRailComDataChangedMessage() {
        return this.getOpCode() == 136;
    }

    int getNumRailComDataEntries() {
        if (!this.isRailComDataChangedMessage()) {
            return 0;
        }
        return (this.getLength() - 4) / 13;
    }

    DccLocoAddress getRailComLocoAddress(int n) {
        int address;
        int offset = 4 + n * 13;
        return new DccLocoAddress(address, (address = Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset)) >= 100);
    }

    int getRailComRcvCount(int n) {
        int offset = 6 + n * 13;
        return ((0xFF & this.getElement(offset + 3)) << 24) + ((0xFF & this.getElement(offset + 2) << 16) + ((0xFF & this.getElement(offset + 1)) << 8) + (0xFF & this.getElement(offset)));
    }

    int getRailComErrCount(int n) {
        int offset = 10 + n * 13;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    int getRailComSpeed(int n) {
        int options = this.getRailComOptions(n);
        if ((options & 1) == 1 || (options & 2) == 2) {
            int offset = 14 + n * 13;
            return 0xFF & this.getElement(offset);
        }
        return 0;
    }

    int getRailComOptions(int n) {
        int offset = 13 + n * 13;
        return 0xFF & this.getElement(offset);
    }

    int getRailComQos(int n) {
        if ((this.getRailComOptions(n) & 4) == 4) {
            int offset = 15 + n * 13;
            return 0xFF & this.getElement(offset);
        }
        return 0;
    }

    boolean isSystemDataChangedReply() {
        return this.getOpCode() == 132;
    }

    private void checkSystemDataChangeReply() {
        if (!this.isSystemDataChangedReply()) {
            throw new IllegalArgumentException(WRONG_REPLY_TYPE);
        }
    }

    int getSystemDataMainCurrent() {
        this.checkSystemDataChangeReply();
        int offset = 4;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    int getSystemDataProgCurrent() {
        this.checkSystemDataChangeReply();
        int offset = 6;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    int getSystemDataFilteredMainCurrent() {
        this.checkSystemDataChangeReply();
        int offset = 8;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    int getSystemDataTemperature() {
        this.checkSystemDataChangeReply();
        int offset = 10;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    int getSystemDataSupplyVoltage() {
        this.checkSystemDataChangeReply();
        int offset = 12;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    int getSystemDataVCCVoltage() {
        this.checkSystemDataChangeReply();
        int offset = 14;
        return Z21MessageUtils.integer16BitFromOffeset(this._dataChars, offset);
    }

    boolean isLocoNetTunnelMessage() {
        switch (this.getOpCode()) {
            case 160: 
            case 161: 
            case 162: {
                return true;
            }
        }
        return false;
    }

    boolean isLocoNetDispatchMessage() {
        return this.getOpCode() == 163;
    }

    boolean isLocoNetDetectorMessage() {
        return this.getOpCode() == 164;
    }

    LocoNetMessage getLocoNetMessage() {
        LocoNetMessage lnr = null;
        if (this.isLocoNetTunnelMessage()) {
            int i = 4;
            lnr = new LocoNetMessage(this.getLength() - 4);
            while (i < this.getLength()) {
                lnr.setElement(i - 4, this.getElement(i));
                ++i;
            }
        }
        return lnr;
    }

    boolean isRMBusDataChangedReply() {
        return this.getOpCode() == 128;
    }

    boolean isCanDetectorMessage() {
        return this.getOpCode() == 196;
    }

    String getCanDetectorLocoAddressString(int addressValue) {
        String addressString;
        if (!this.isCanDetectorMessage()) {
            return "";
        }
        if (addressValue == 0) {
            addressString = "end of list";
        } else {
            addressString = this.getCanDetectorLocoAddress(addressValue).toString();
            int direction = 0xC000 & addressValue;
            switch (direction) {
                case 32768: {
                    addressString = String.valueOf(addressString) + " direction forward";
                    break;
                }
                case 49152: {
                    addressString = String.valueOf(addressString) + " direction reverse";
                    break;
                }
                default: {
                    addressString = String.valueOf(addressString) + " direction unknown";
                }
            }
        }
        return addressString;
    }

    DccLocoAddress getCanDetectorLocoAddress(int addressValue) {
        int locoAddress;
        if (!this.isCanDetectorMessage()) {
            return null;
        }
        if (addressValue == 0) {
            return null;
        }
        return new DccLocoAddress(locoAddress, (locoAddress = 0x3FFF & addressValue) >= 100);
    }

    public int canDetectorMessageType() {
        if (this.isCanDetectorMessage()) {
            return this.getElement(9) & 0xFF;
        }
        return -1;
    }

    public boolean isCanSensorMessage() {
        return this.isCanDetectorMessage() && this.canDetectorMessageType() == 1;
    }

    public boolean isCanReporterMessage() {
        int type = this.canDetectorMessageType();
        return this.isCanDetectorMessage() && type >= 17 && type <= 31;
    }
}

