/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.roco.z21.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21RMBusAddress {
    static final int MINSENSORADDRESS = 1;
    static final int MAXSENSORADDRESS = 160;
    private static final Logger log = LoggerFactory.getLogger(Z21RMBusAddress.class);

    private Z21RMBusAddress() {
    }

    public static int getBitFromSystemName(String systemName, String prefix) {
        int num;
        if (!systemName.startsWith(prefix)) {
            log.error("invalid character in header field of Z21 RM Bus system name: {}", (Object)systemName);
            return -1;
        }
        try {
            String curAddress = systemName.substring(prefix.length() + 1);
            num = Integer.parseInt(curAddress);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid character in number field of system name: {}", (Object)systemName);
            return -1;
        }
        if (num >= 1 && num <= 160) {
            return num;
        }
        log.warn("Z21 RM Bus hardware address out of range in system name {}", (Object)systemName);
        return -1;
    }

    public static String validateSystemNameFormat(String name, Manager manager, Locale locale) {
        try {
            return manager.validateIntegerSystemNameFormat(name, 1, 160, locale);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "SystemNameInvalidRMAddress", name), Bundle.getMessage(locale, "SystemNameInvalidRMAddress", name));
        }
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        if (!systemName.startsWith(String.valueOf(prefix) + type)) {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        int address = Z21RMBusAddress.getBitFromSystemName(systemName, prefix);
        if (address >= 0 && address <= 160) {
            return Manager.NameValidity.VALID;
        }
        return Manager.NameValidity.INVALID;
    }

    public static String getUserNameFromSystemName(String systemName, String prefix) {
        if (systemName.length() < prefix.length() + 2 || !systemName.startsWith(prefix)) {
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'S') {
            Sensor s = InstanceManager.sensorManagerInstance().getBySystemName(systemName);
            if (s != null) {
                return s.getUserName();
            }
            return "";
        }
        return "";
    }
}

