/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.lenz.XNetMessage;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.roco.z21.Bundle;
import jmri.jmrix.roco.z21.Z21MessageUtils;
import jmri.jmrix.roco.z21.Z21XNetMessage;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21Message
extends AbstractMRMessage {
    private static final Logger log = LoggerFactory.getLogger(Z21Message.class);

    public Z21Message() {
        this.setBinary(true);
    }

    public Z21Message(int i) {
        this();
        if (i < 4) {
            log.error("invalid length in call to ctor");
        }
        this._nDataChars = i;
        this._dataChars = new int[i];
        this.setLength(i);
    }

    public Z21Message(XNetMessage m) {
        this(m.getNumDataElements() + 4);
        this.setOpCode(64);
        int i = 0;
        while (i < m.getNumDataElements()) {
            this.setElement(i + 4, m.getElement(i));
            ++i;
        }
    }

    public Z21Message(LocoNetMessage m) {
        this(m.getNumDataElements() + 4);
        this.setOpCode(162);
        int i = 0;
        while (i < m.getNumDataElements()) {
            this.setElement(i + 4, m.getElement(i));
            ++i;
        }
    }

    public Z21Message(String m) {
        super(m);
        this.setBinary(true);
        byte[] b = StringUtil.bytesFromHexString(m);
        if (b.length == 0) {
            this._nDataChars = 0;
            this._dataChars = null;
            return;
        }
        this._nDataChars = b.length;
        this._dataChars = new int[this._nDataChars];
        int i = 0;
        while (i < b.length) {
            this.setElement(i, b[i]);
            ++i;
        }
    }

    public Z21Message(byte[] a, int l) {
        super(String.valueOf(a));
        this.setBinary(true);
    }

    @Override
    public void setOpCode(int i) {
        this._dataChars[2] = i & 0xFF;
        this._dataChars[3] = (i & 0xFF00) >> 8;
    }

    @Override
    public int getOpCode() {
        return (0xFF & this._dataChars[2]) + ((0xFF & this._dataChars[3]) << 8);
    }

    public void setLength(int i) {
        this._dataChars[0] = i & 0xFF;
        this._dataChars[1] = (i & 0xFF00) >> 8;
    }

    public int getLength() {
        return this._dataChars[0] + (this._dataChars[1] << 8);
    }

    byte[] getBuffer() {
        byte[] byteData = new byte[this._dataChars.length];
        int i = 0;
        while (i < this._dataChars.length) {
            byteData[i] = (byte)(0xFF & this._dataChars[i]);
            ++i;
        }
        return byteData;
    }

    public static Z21Message getSerialNumberRequestMessage() {
        Z21Message retval = new Z21Message(4);
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 16);
        retval.setElement(3, 0);
        return retval;
    }

    public static Z21Message getLanGetHardwareInfoRequestMessage() {
        Z21Message retval = new Z21Message(4);
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 26);
        retval.setElement(3, 0);
        return retval;
    }

    public static Z21Message getLanLogoffRequestMessage() {
        Z21Message retval = new Z21Message(4){

            @Override
            public boolean replyExpected() {
                return false;
            }
        };
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 48);
        retval.setElement(3, 0);
        return retval;
    }

    public static Z21Message getLanGetBroadcastFlagsRequestMessage() {
        Z21Message retval = new Z21Message(4);
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 81);
        retval.setElement(3, 0);
        return retval;
    }

    public static Z21Message getLanSetBroadcastFlagsRequestMessage(int flags) {
        Z21Message retval = new Z21Message(8){

            @Override
            public boolean replyExpected() {
                return false;
            }
        };
        retval.setElement(0, 8);
        retval.setElement(1, 0);
        retval.setElement(2, 80);
        retval.setElement(3, 0);
        retval.setElement(4, flags & 0xFF);
        retval.setElement(5, (flags & 0xFF00) >> 8);
        retval.setElement(6, (flags & 0xFF0000) >> 16);
        retval.setElement(7, (flags & 0xFF000000) >> 24);
        return retval;
    }

    public static Z21Message getLanRailComGetDataRequestMessage() {
        Z21Message retval = new Z21Message(4);
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 137);
        retval.setElement(3, 0);
        return retval;
    }

    public static Z21Message getLanSystemStateDataChangedRequestMessage() {
        Z21Message retval = new Z21Message(4);
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 133);
        retval.setElement(3, 0);
        return retval;
    }

    @Override
    public String toMonitorString() {
        switch (this.getOpCode()) {
            case 16: {
                return Bundle.getMessage("Z21MessageStringSerialNoRequest");
            }
            case 26: {
                return Bundle.getMessage("Z21MessageStringVersionRequest");
            }
            case 64: {
                return Bundle.getMessage("Z21MessageXpressNetTunnelRequest", new Z21XNetMessage(this).toMonitorString());
            }
            case 80: {
                return Bundle.getMessage("Z21MessageSetBroadcastFlags", Z21MessageUtils.interpretBroadcastFlags(this._dataChars));
            }
            case 81: {
                return Bundle.getMessage("Z21MessageRequestBroadcastFlags");
            }
            case 162: {
                return Bundle.getMessage("Z21LocoNetLanMessage", this.getLocoNetMessage().toMonitorString());
            }
            case 129: {
                return Bundle.getMessage("Z21RMBusGetDataRequest", this.getElement(4));
            }
            case 130: {
                return Bundle.getMessage("Z21RMBusProgramModuleRequest", this.getElement(4));
            }
            case 137: {
                return Bundle.getMessage("Z21_RAILCOM_GETDATA");
            }
            case 196: {
                int networkID = (this.getElement(4) & 0xFF) + ((this.getElement(5) & 0xFF) << 8);
                return Bundle.getMessage("Z21CANDetectorRequest", networkID);
            }
        }
        return this.toString();
    }

    boolean isLocoNetTunnelMessage() {
        return this.getOpCode() == 162;
    }

    boolean isLocoNetDispatchMessage() {
        return this.getOpCode() == 163;
    }

    boolean isLocoNetDetectorMessage() {
        return this.getOpCode() == 164;
    }

    LocoNetMessage getLocoNetMessage() {
        LocoNetMessage lnr = null;
        if (this.isLocoNetTunnelMessage()) {
            int i = 4;
            lnr = new LocoNetMessage(this.getLength() - 4);
            while (i < this.getLength()) {
                lnr.setElement(i - 4, this.getElement(i));
                ++i;
            }
        }
        return lnr;
    }

    public static Z21Message getLanRMBusGetDataRequestMessage(int group) {
        if (group != 0 && group != 1) {
            throw new IllegalArgumentException("RMBus Group not 0 or 1");
        }
        Z21Message retval = new Z21Message(5);
        retval.setElement(0, 4);
        retval.setElement(1, 0);
        retval.setElement(2, 129);
        retval.setElement(3, 0);
        retval.setElement(4, group & 0xFF);
        return retval;
    }

    public static Z21Message getLanRMBusProgramModuleMessage(int address) {
        if (address > 20) {
            throw new IllegalArgumentException("RMBus Address > 20");
        }
        Z21Message retval = new Z21Message(5);
        retval.setElement(0, 5);
        retval.setElement(1, 0);
        retval.setElement(2, 130);
        retval.setElement(3, 0);
        retval.setElement(4, address & 0xFF);
        return retval;
    }

    boolean isCanDetectorMessage() {
        return this.getOpCode() == 196;
    }

    public static Z21Message getLanCanDetector(int address) {
        Z21Message retval = new Z21Message(7);
        retval.setElement(0, 7);
        retval.setElement(1, 0);
        retval.setElement(2, 196);
        retval.setElement(3, 0);
        retval.setElement(4, 0);
        retval.setElement(5, address & 0xFF);
        retval.setElement(6, (address & 0xFF00) >> 8);
        return retval;
    }
}

