/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.loconet.LocoNetListener;
import jmri.jmrix.loconet.LocoNetMessage;
import jmri.jmrix.loconet.LocoNetMessageException;
import jmri.jmrix.loconet.LocoNetSystemConnectionMemo;
import jmri.jmrix.loconet.streamport.LnStreamPortController;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21LnStreamPortController;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21LocoNetTunnel
implements Z21Listener,
LocoNetListener,
Runnable {
    LnStreamPortController lsc = null;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private DataOutputStream outpipe = null;
    private DataInputStream inpipe = null;
    private Z21SystemConnectionMemo _memo;
    private Thread sourceThread;
    private static final Logger log = LoggerFactory.getLogger(Z21LocoNetTunnel.class);

    @SuppressFBWarnings(value={"SC_START_IN_CTOR"}, justification="done at end, waits for data")
    public Z21LocoNetTunnel(Z21SystemConnectionMemo memo) {
        this._memo = memo;
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            this.inpipe = new DataInputStream(new PipedInputStream(tempPipeI));
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.outpipe = new DataOutputStream(tempPipeO);
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
            return;
        }
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("z21.Z21LocoNetTunnel sourceThread");
        this.sourceThread.setDaemon(true);
        this.sourceThread.start();
        LocoNetSystemConnectionMemo lnMemo = new LocoNetSystemConnectionMemo();
        this.setStreamPortController(new Z21LnStreamPortController(lnMemo, this.pin, this.pout, "None"));
        this._memo.getTrafficController().addz21Listener(this);
        this.lsc.configure();
    }

    @Override
    public void run() {
        log.debug("LocoNet Tunnel Thread Started");
        while (true) {
            LocoNetMessage m;
            if ((m = this.readMessage()) == null) {
                continue;
            }
            this.message(m);
        }
    }

    private LocoNetMessage readMessage() {
        LocoNetMessage msg = null;
        try {
            msg = this.loadChars();
        }
        catch (IOException | LocoNetMessageException exception) {}
        return msg;
    }

    private LocoNetMessage loadChars() throws IOException, LocoNetMessageException {
        int opCode;
        while (((opCode = this.readByteProtected(this.inpipe) & 0xFF) & 0x80) == 0) {
            log.trace("Skipping: {}", (Object)Integer.toHexString(opCode));
        }
        log.trace(" (RcvHandler) Start message with opcode: {}", (Object)Integer.toHexString(opCode));
        LocoNetMessage msg = null;
        while (msg == null) {
            try {
                int byte2 = this.readByteProtected(this.inpipe) & 0xFF;
                log.trace("Byte2: {}", (Object)Integer.toHexString(byte2));
                int len = 2;
                switch ((opCode & 0x60) >> 5) {
                    case 0: {
                        len = 2;
                        break;
                    }
                    case 1: {
                        len = 4;
                        break;
                    }
                    case 2: {
                        len = 6;
                        break;
                    }
                    case 3: {
                        if (byte2 < 2) {
                            log.error("LocoNet message length invalid: {} opcode: {}", (Object)byte2, (Object)Integer.toHexString(opCode));
                        }
                        len = byte2;
                        break;
                    }
                    default: {
                        log.warn("Unhandled code: {}", (Object)((opCode & 0x60) >> 5));
                    }
                }
                msg = new LocoNetMessage(len);
                msg.setOpCode(opCode);
                msg.setElement(1, byte2);
                log.trace("len: {}", (Object)len);
                int i = 2;
                while (i < len) {
                    int b = this.readByteProtected(this.inpipe) & 0xFF;
                    log.trace("char {} is: {}", (Object)i, (Object)Integer.toHexString(b));
                    if ((b & 0x80) != 0) {
                        log.warn("LocoNet message with opCode: {} ended early. Expected length: {} seen length: {} unexpected byte: {}", new Object[]{Integer.toHexString(opCode), len, i, Integer.toHexString(b)});
                        opCode = b;
                        throw new LocoNetMessageException();
                    }
                    msg.setElement(i, b);
                    ++i;
                }
            }
            catch (LocoNetMessageException locoNetMessageException) {
                msg = null;
            }
        }
        if (!msg.checkParity()) {
            log.warn("Ignore LocoNet packet with bad checksum: {}", (Object)msg);
            throw new LocoNetMessageException();
        }
        return msg;
    }

    private byte readByteProtected(DataInputStream istream) throws IOException {
        int nchars;
        byte[] rcvBuffer = new byte[1];
        while ((nchars = istream.read(rcvBuffer, 0, 1)) <= 0) {
        }
        return rcvBuffer[0];
    }

    @Override
    public void reply(Z21Reply msg) {
        if (msg.isLocoNetTunnelMessage()) {
            LocoNetMessage reply = msg.getLocoNetMessage();
            log.debug("Z21 Reply {} forwarded to XpressNet implementation as {}", (Object)msg, (Object)reply);
            int i = 0;
            while (i < reply.getNumDataElements()) {
                try {
                    this.outpipe.writeByte(reply.getElement(i));
                }
                catch (IOException iOException) {
                    log.error("Error writing XpressNet Reply to XpressNet input stream.");
                }
                ++i;
            }
        }
    }

    @Override
    public void message(Z21Message msg) {
    }

    @Override
    public void message(LocoNetMessage msg) {
        Z21Message message = new Z21Message(msg);
        log.debug("LocoNet Message {} forwarded to z21 Interface as {}", (Object)msg, (Object)message);
        this._memo.getTrafficController().sendz21Message(message, this);
    }

    LnStreamPortController getStreamPortController() {
        return this.lsc;
    }

    void setStreamPortController(LnStreamPortController x) {
        this.lsc = x;
        this.lsc.getSystemConnectionMemo().setSystemPrefix("L");
        this.lsc.getSystemConnectionMemo().setUserName(String.valueOf(this._memo.getUserName()) + "LocoNet");
    }

    public void dispose() {
        if (this.lsc != null) {
            this.lsc.dispose();
        }
        if (this._memo != null) {
            this._memo.dispose();
        }
        this.sourceThread.stop();
        try {
            this.sourceThread.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

