/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import javax.swing.Timer;
import jmri.jmrix.roco.z21.Z21Listener;
import jmri.jmrix.roco.z21.Z21Message;
import jmri.jmrix.roco.z21.Z21Reply;
import jmri.jmrix.roco.z21.Z21SystemConnectionMemo;
import jmri.jmrix.roco.z21.Z21TrafficController;

public class Z21HeartBeat
implements Z21Listener {
    private Timer keepAliveTimer;
    private static final int keepAliveTimeoutValue = 30000;
    private Z21TrafficController tc;

    public Z21HeartBeat(Z21SystemConnectionMemo memo) {
        this.tc = memo.getTrafficController();
        this.tc.addz21Listener(this);
        this.keepAliveTimer();
    }

    private void keepAliveTimer() {
        if (this.keepAliveTimer == null) {
            this.keepAliveTimer = new Timer(30000, e -> this.tc.sendz21Message(Z21Message.getSerialNumberRequestMessage(), null));
        }
        this.keepAliveTimer.stop();
        this.keepAliveTimer.setInitialDelay(30000);
        this.keepAliveTimer.setRepeats(true);
        this.keepAliveTimer.start();
    }

    public void dispose() {
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.stop();
        }
        this.keepAliveTimer = null;
    }

    @Override
    public void reply(Z21Reply msg) {
    }

    @Override
    public void message(Z21Message msg) {
        if (this.keepAliveTimer != null) {
            this.keepAliveTimer.restart();
        }
    }
}

