/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.roco.z21;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.Sensor;
import jmri.jmrix.roco.z21.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z21CanBusAddress {
    private static final Logger log = LoggerFactory.getLogger(Z21CanBusAddress.class);

    private Z21CanBusAddress() {
    }

    public static int getBitFromSystemName(String systemName, String prefix) {
        if (!Z21CanBusAddress.systemNameStartsWithPrefix(systemName, prefix)) {
            return -1;
        }
        try {
            String curAddress = systemName.substring(prefix.length() + 1);
            if ((systemName.charAt(prefix.length()) == 'R' || systemName.charAt(prefix.length()) == 'r' || systemName.charAt(prefix.length()) == 'S' || systemName.charAt(prefix.length()) == 's') && curAddress.contains(":")) {
                int seperator = curAddress.indexOf(58);
                int encoderAddress = Z21CanBusAddress.parseEncoderAddress(curAddress, 0, seperator);
                log.debug("found module address {}", (Object)encoderAddress);
                return Integer.parseInt(curAddress.substring(seperator + 1));
            }
            log.warn("system name {} is in the wrong format.  Should be mm:pp.", (Object)systemName);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("invalid character in number field of system name: {}", (Object)systemName);
        }
        return -1;
    }

    private static boolean systemNameStartsWithPrefix(String systemName, String prefix) {
        if (!systemName.startsWith(prefix)) {
            log.error("invalid character in header field of Z21 Can Bus system name: {}", (Object)systemName);
            return false;
        }
        return true;
    }

    private static int parseEncoderAddress(String addressWithoutPrefix, int start, int end) {
        int encoderAddress;
        try {
            encoderAddress = Integer.parseInt(addressWithoutPrefix.substring(start, end));
        }
        catch (NumberFormatException numberFormatException) {
            encoderAddress = Integer.parseInt(addressWithoutPrefix.substring(start, end), 16);
        }
        return encoderAddress;
    }

    public static String getEncoderAddressString(String systemName, String prefix) {
        if (!Z21CanBusAddress.systemNameStartsWithPrefix(systemName, prefix)) {
            throw new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, "InvalidSystemNameInvalidPrefix", prefix), Bundle.getMessage("InvalidSystemNameInvalidPrefix", prefix));
        }
        int seperator = systemName.indexOf(58);
        return systemName.substring(prefix.length() + 1, seperator);
    }

    public static String validateSystemNameFormat(String name, Manager manager, Locale locale) {
        int num;
        String[] parts = (name = manager.validateSystemNamePrefix(name, locale)).substring(manager.getSystemNamePrefix().length()).split(":");
        if (parts.length != 2) {
            throw Z21CanBusAddress.newBadSystemNameException(name, "SystemNameInvalidMissingParts", locale);
        }
        try {
            num = Z21CanBusAddress.parseEncoderAddress(parts[0], 0, parts[0].length());
            if (num < 0 || num > 65535) {
                throw Z21CanBusAddress.newBadSystemNameException(name, "SysteNameInvalidCanAddress", locale);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Z21CanBusAddress.newBadSystemNameException(name, "SysteNameInvalidCanAddress", locale);
        }
        try {
            num = Integer.parseInt(parts[1]);
            if (num < 0 || num > 7) {
                throw Z21CanBusAddress.newBadSystemNameException(name, "SystemNameInvalidPin", locale);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw Z21CanBusAddress.newBadSystemNameException(name, "SystemNameInvalidPin", locale);
        }
        return name;
    }

    private static NamedBean.BadSystemNameException newBadSystemNameException(String name, String reasonKey, Locale locale) {
        return new NamedBean.BadSystemNameException(Bundle.getMessage(Locale.ENGLISH, reasonKey, name), Bundle.getMessage(locale, reasonKey, name));
    }

    public static Manager.NameValidity validSystemNameFormat(@Nonnull String systemName, char type, String prefix) {
        if (!systemName.startsWith(String.valueOf(prefix) + type)) {
            log.error("invalid character in header field of system name: {}", (Object)systemName);
            return Manager.NameValidity.INVALID;
        }
        if (Z21CanBusAddress.getBitFromSystemName(systemName, prefix) >= 0) {
            return Manager.NameValidity.VALID;
        }
        return Manager.NameValidity.INVALID;
    }

    public static String getUserNameFromSystemName(String systemName, String prefix) {
        if (systemName.length() < prefix.length() + 2 || !systemName.startsWith(prefix)) {
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'R') {
            Reporter r = InstanceManager.getDefault(ReporterManager.class).getBySystemName(systemName);
            if (r != null) {
                return r.getUserName();
            }
            return "";
        }
        if (systemName.charAt(prefix.length() + 1) == 'S') {
            Sensor s = InstanceManager.sensorManagerInstance().getBySystemName(systemName);
            if (s != null) {
                return s.getUserName();
            }
            return "";
        }
        return "";
    }

    public static String buildDecimalSystemNameFromParts(String prefix, char typeLetter, int userAddress, int pin) {
        return String.format("%s%c%d:%d", prefix, Character.valueOf(typeLetter), userAddress, pin);
    }

    public static String buildHexSystemNameFromParts(String prefix, char typeLetter, int globalCANaddress, int pin) {
        return String.format("%s%c%4X:%d", prefix, Character.valueOf(typeLetter), globalCANaddress, pin);
    }
}

