/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.serialdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.rfid.RfidPortController;
import jmri.jmrix.rfid.RfidProtocol;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.generic.standalone.StandaloneReporterManager;
import jmri.jmrix.rfid.generic.standalone.StandaloneSensorManager;
import jmri.jmrix.rfid.generic.standalone.StandaloneTrafficController;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorReporterManager;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorSensorManager;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorTrafficController;
import jmri.jmrix.rfid.protocol.coreid.CoreIdRfidProtocol;
import jmri.jmrix.rfid.protocol.em18.Em18RfidProtocol;
import jmri.jmrix.rfid.protocol.olimex.OlimexRfid1356mifareProtocol;
import jmri.jmrix.rfid.protocol.olimex.OlimexRfidProtocol;
import jmri.jmrix.rfid.protocol.parallax.ParallaxRfidProtocol;
import jmri.jmrix.rfid.protocol.seeedstudio.SeeedStudioRfidProtocol;
import jmri.jmrix.rfid.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class SerialDriverAdapter
extends RfidPortController {
    SerialPort activeSerialPort = null;
    protected String[] validSpeeds = new String[]{Bundle.getMessage("BaudAutomatic")};
    protected int[] validSpeedValues = new int[]{9600};
    private boolean opened = false;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new RfidSystemConnectionMemo());
        this.option1Name = "Adapter";
        this.option2Name = "Concentrator-Range";
        this.option3Name = "Protocol";
        this.option4Name = "Device";
        this.options.put(this.option1Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionAdapter"), new String[]{"Generic Stand-alone", "MERG Concentrator"}, false));
        this.options.put(this.option2Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionConcentratorRange"), new String[]{"A-H", "I-P"}, false));
        this.options.put(this.option3Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionProtocol"), new String[]{"CORE-ID", "Olimex", "Parallax", "SeeedStudio", "EM-18"}, false));
        this.options.put(this.option4Name, new AbstractPortController.Option(Bundle.getMessage("ConnectionDeviceType"), new String[]{"MOD-RFID125", "MOD-RFID1356MIFARE"}, false));
        this.manufacturerName = "RFID";
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort();
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            try {
                log.debug("Serial framing was observed as: {} {}", (Object)this.activeSerialPort.isReceiveFramingEnabled(), (Object)this.activeSerialPort.getReceiveFramingByte());
            }
            catch (Exception ef) {
                log.debug("failed to set serial framing: {}", (Throwable)ef);
            }
            try {
                this.activeSerialPort.enableReceiveTimeout(10);
                log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            }
            catch (UnsupportedCommOperationException et) {
                log.info("failed to set serial timeout: {}", (Throwable)et);
            }
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {}", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void configure() {
        RfidProtocol protocol;
        RfidTrafficController control;
        block43: {
            String opt4;
            String opt3;
            block41: {
                String opt2;
                String opt1;
                switch (opt1 = this.getOptionState(this.option1Name)) {
                    case "Generic Stand-alone": {
                        log.debug("Create Generic Standalone SpecificTrafficController");
                        control = new StandaloneTrafficController(this.getSystemConnectionMemo());
                        this.getSystemConnectionMemo().setRfidTrafficController(control);
                        this.getSystemConnectionMemo().configureManagers(new StandaloneSensorManager(this.getSystemConnectionMemo()), new StandaloneReporterManager(this.getSystemConnectionMemo()));
                        break;
                    }
                    case "MERG Concentrator": {
                        log.debug("Create MERG Concentrator SpecificTrafficController");
                        control = new ConcentratorTrafficController(this.getSystemConnectionMemo(), this.getOptionState(this.option2Name));
                        this.getSystemConnectionMemo().setRfidTrafficController(control);
                        this.getSystemConnectionMemo().configureManagers(new ConcentratorSensorManager(this.getSystemConnectionMemo()), new ConcentratorReporterManager(this.getSystemConnectionMemo()));
                        break;
                    }
                    default: {
                        log.warn("adapter option {} defaults to Generic Stand-alone", (Object)opt1);
                        control = new StandaloneTrafficController(this.getSystemConnectionMemo());
                        this.getSystemConnectionMemo().setRfidTrafficController(control);
                        this.getSystemConnectionMemo().configureManagers(new StandaloneSensorManager(this.getSystemConnectionMemo()), new StandaloneReporterManager(this.getSystemConnectionMemo()));
                    }
                }
                opt3 = this.getOptionState(this.option3Name);
                opt4 = this.getOptionState(this.option4Name);
                if (!opt1.equals("MERG Concentrator")) break block41;
                log.info("set protocol to CORE-ID");
                switch (opt2 = this.getOptionState(this.option2Name)) {
                    case "A-H": {
                        log.info("set concentrator range to 'A-H' at position 1");
                        protocol = new CoreIdRfidProtocol('A', 'H', 1);
                        break;
                    }
                    case "I-P": {
                        log.info("set concentrator range to 'I-P' at position 1");
                        protocol = new CoreIdRfidProtocol('I', 'P', 1);
                        break;
                    }
                    default: {
                        log.warn("concentrator range '{}' not supported - default to no concentrator", (Object)opt2);
                        protocol = new CoreIdRfidProtocol();
                        break;
                    }
                }
                break block43;
            }
            switch (opt3) {
                case "CORE-ID": {
                    log.info("set protocol to CORE-ID");
                    protocol = new CoreIdRfidProtocol();
                    break;
                }
                case "Olimex": {
                    if (opt4.equals("MOD-RFID1356MIFARE")) {
                        log.info("set protocol for Olimex MOD-RFID1356MIFARE");
                        protocol = new OlimexRfid1356mifareProtocol();
                        break;
                    }
                    log.info("set protocol for Olimex MOD-RFID125");
                    protocol = new OlimexRfidProtocol();
                    break;
                }
                case "Parallax": {
                    log.info("set protocol to Parallax");
                    protocol = new ParallaxRfidProtocol();
                    break;
                }
                case "SeeedStudio": {
                    log.info("set protocol to SeeedStudio");
                    protocol = new SeeedStudioRfidProtocol();
                    break;
                }
                case "EM-18": {
                    log.info("set protocol to EM-18");
                    protocol = new Em18RfidProtocol();
                    break;
                }
                default: {
                    log.warn("protocol option {} defaults to CORE-ID", (Object)opt3);
                    protocol = new CoreIdRfidProtocol();
                }
            }
        }
        this.getSystemConnectionMemo().setProtocol(protocol);
        this.getSystemConnectionMemo().setRfidTrafficController(control);
        control.setAdapterMemo(this.getSystemConnectionMemo());
        control.connectPort(this);
        control.sendInitString();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort() throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        if (this.getOptionState(this.option3Name).equals("Parallax")) {
            log.debug("Set baud rate to 2400 for Parallax reader");
            baud = 2400;
        }
        this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 0;
        if (this.getOptionState(this.option1Name).equals("MERG Concentrator")) {
            log.debug("Set hardware flow control for Concentrator");
            flow = 2;
        }
        this.configureLeadsAndFlowControl(this.activeSerialPort, flow);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

