/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.protocol.olimex;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlimexRfidProtocol
extends RfidProtocol {
    public static final int SPECIFICMAXSIZE = 16;
    private static final Logger log = LoggerFactory.getLogger(OlimexRfidProtocol.class);

    public static final int getMaxSize() {
        return 16;
    }

    @Override
    public String initString() {
        return "mc00";
    }

    @Override
    public String getTag(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(10);
        int i = 3;
        while (i < 13) {
            sb.append((char)msg.getElement(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getCheckSum(AbstractMRReply msg) {
        return "";
    }

    @Override
    public boolean isValid(AbstractMRReply msg) {
        return (!this.isConcentrator && msg.getElement(2) == 45 || this.isConcentrator && msg.getElement(this.portPosition) >= this.concentratorFirst && msg.getElement(this.portPosition) <= this.concentratorLast) && msg.getElement(15) == 62;
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() == 16) {
            if ((msg.getElement(15) & 0xFF) == 62 && (msg.getElement(14) & 0xFF) == 10 && (msg.getElement(13) & 0xFF) == 13) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a correctly formed message");
            }
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString(AbstractMRReply msg) {
        if (this.isValid(msg)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Reply from Olimex reader.");
            if (this.isConcentrator) {
                sb.append(" Reply from port ");
                sb.append(this.getReaderPort(msg));
            }
            sb.append(" Tag read ");
            sb.append(this.getTag(msg));
            return sb.toString();
        }
        return super.toMonitorString(msg);
    }
}

