/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.protocol.olimex;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlimexRfid1356mifareProtocol
extends RfidProtocol {
    public static final int SPECIFICMAXSIZE = 13;
    public final String initialize = "mt100\r\ne0\r\n";
    private static final Logger log = LoggerFactory.getLogger((String)OlimexRfid1356mifareProtocol.class.getName());

    public static final int getMaxSize() {
        return 13;
    }

    @Override
    public String initString() {
        return "mt100\r\ne0\r\n";
    }

    @Override
    public String getTag(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(10);
        int i = 3;
        while (i < 11) {
            sb.append((char)msg.getElement(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public String getCheckSum(AbstractMRReply msg) {
        return "";
    }

    @Override
    public boolean isValid(AbstractMRReply msg) {
        return (!this.isConcentrator && msg.getElement(2) == 45 || this.isConcentrator && msg.getElement(this.portPosition) >= this.concentratorFirst && msg.getElement(this.portPosition) <= this.concentratorLast) && msg.getElement(12) == 10;
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() == 13) {
            if ((msg.getElement(12) & 0xFF) == 10 && (msg.getElement(11) & 0xFF) == 13 && (msg.getElement(10) & 0xFF) != 13 && (msg.getElement(10) & 0xFF) != 10) {
                return true;
            }
            int i = 0;
            while (i < "mt100\r\ne0\r\n".length()) {
                if (msg.getElement(i) != "mt100\r\ne0\r\n".charAt(i)) {
                    return false;
                }
                ++i;
            }
            if (msg.getElement(i) != 79) {
                return false;
            }
            if (msg.getElement(i + 1) != 75) {
                return false;
            }
            if (msg.getElement(i + 2) != 10) {
                return false;
            }
            if (msg.getElement(i + 3) != 13) {
                return false;
            }
            if (msg.getElement(i + 4) != 62) {
                return false;
            }
            if (msg.getElement(i + 5) != 7) {
                return false;
            }
            if (msg.getElement(i + 6) != 101) {
                return false;
            }
            if (msg.getElement(i + 7) != 48) {
                return false;
            }
            if (msg.getElement(i + 8) != 10) {
                return false;
            }
            if (msg.getElement(i + 9) != 13) {
                return false;
            }
            if (msg.getElement(i + 10) != 79) {
                return false;
            }
            if (msg.getElement(i + 11) != 75) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a correctly formed message");
            }
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString(AbstractMRReply msg) {
        if (this.isValid(msg)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Reply from Olimex MOD-RFID1356MIFARE reader.");
            if (this.isConcentrator) {
                sb.append(" Reply from port ");
                sb.append(this.getReaderPort(msg));
            }
            sb.append(" Tag read ");
            sb.append(this.getTag(msg));
            return sb.toString();
        }
        return super.toMonitorString(msg);
    }
}

