/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.protocol.em18;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Em18RfidProtocol
extends RfidProtocol {
    private static final int SPECIFICMAXSIZE = 12;
    private static final Logger log = LoggerFactory.getLogger(Em18RfidProtocol.class);

    public Em18RfidProtocol() {
    }

    public Em18RfidProtocol(char concentratorFirst, char concentratorLast, int portPosition) {
        super(concentratorFirst, concentratorLast, portPosition);
    }

    public static final int getMaxSize() {
        return 12;
    }

    @Override
    public String initString() {
        return "";
    }

    @Override
    public String getTag(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(10);
        int i = 0;
        while (i < 10) {
            sb.append((char)msg.getElement(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public boolean providesChecksum() {
        return true;
    }

    @Override
    public String getCheckSum(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(2);
        int i = 10;
        while (i < 12) {
            sb.append((char)msg.getElement(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public boolean isValid(AbstractMRReply msg) {
        return (!this.isConcentrator && msg.getElement(0) != 2 && (msg.getElement(11) & 0xFF) != 3 || this.isConcentrator && msg.getElement(this.portPosition) >= this.concentratorFirst && msg.getElement(this.portPosition) <= this.concentratorLast && (msg.getElement(11) & 0xFF) != 62) && this.isCheckSumValid(msg);
    }

    public boolean isCheckSumValid(AbstractMRReply msg) {
        byte[] tag = Em18RfidProtocol.convertHexString(this.getTag(msg));
        int checksum = 0;
        int i = 0;
        while (i < 5) {
            checksum ^= tag[i];
            log.debug("read {}", (Object)tag[i]);
            ++i;
        }
        log.debug("Checksum: {} converted: {}", (Object)this.getCheckSum(msg), (Object)Em18RfidProtocol.convertHexString(this.getCheckSum(msg))[0]);
        return checksum == Em18RfidProtocol.convertHexString(this.getCheckSum(msg))[0];
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() == 12) {
            if (((msg.getElement(11) & 0xFF) == 3 || (msg.getElement(11) & 0xFF) == 62) && (msg.getElement(10) & 0xFF) == 10 && (msg.getElement(9) & 0xFF) == 13) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a correctly formed message");
            }
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString(AbstractMRReply msg) {
        if (this.isValid(msg)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Reply from EM-18 reader.");
            if (this.isConcentrator) {
                sb.append(" Reply from port ");
                sb.append(this.getReaderPort(msg));
            }
            sb.append(" Tag read ");
            sb.append(this.getTag(msg));
            sb.append(" checksum ");
            sb.append(this.getCheckSum(msg));
            sb.append(" valid? ");
            sb.append(this.isCheckSumValid(msg) ? "yes" : "no");
            return sb.toString();
        }
        return super.toMonitorString(msg);
    }
}

