/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.protocol.coreid;

import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreIdRfidProtocol
extends RfidProtocol {
    private static final int SPECIFICMAXSIZE = 16;
    private static final Logger log = LoggerFactory.getLogger(CoreIdRfidProtocol.class);

    public CoreIdRfidProtocol() {
    }

    public CoreIdRfidProtocol(char concentratorFirst, char concentratorLast, int portPosition) {
        super(concentratorFirst, concentratorLast, portPosition);
    }

    public static final int getMaxSize() {
        return 16;
    }

    @Override
    public String initString() {
        return "";
    }

    @Override
    public String getTag(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(10);
        int i = 1;
        while (i < 11) {
            sb.append((char)msg.getElement(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public boolean providesChecksum() {
        return true;
    }

    @Override
    public String getCheckSum(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder(2);
        int i = 11;
        while (i < 13) {
            sb.append((char)msg.getElement(i));
            ++i;
        }
        return sb.toString();
    }

    @Override
    public boolean isValid(AbstractMRReply msg) {
        return (!this.isConcentrator && msg.getElement(0) == 2 && (msg.getElement(15) & 0xFF) == 3 || this.isConcentrator && msg.getElement(this.portPosition) >= this.concentratorFirst && msg.getElement(this.portPosition) <= this.concentratorLast && (msg.getElement(15) & 0xFF) == 62) && (msg.getElement(14) & 0xFF) == 10 && (msg.getElement(13) & 0xFF) == 13 && this.isCheckSumValid(msg);
    }

    public boolean isCheckSumValid(AbstractMRReply msg) {
        byte[] tag = CoreIdRfidProtocol.convertHexString(this.getTag(msg));
        int checksum = 0;
        int i = 0;
        while (i < 5) {
            checksum ^= tag[i];
            log.debug("read {}", (Object)tag[i]);
            ++i;
        }
        log.debug("Checksum: {} converted: {}", (Object)this.getCheckSum(msg), (Object)CoreIdRfidProtocol.convertHexString(this.getCheckSum(msg))[0]);
        return checksum == CoreIdRfidProtocol.convertHexString(this.getCheckSum(msg))[0];
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() == 16) {
            if (((msg.getElement(15) & 0xFF) == 3 || (msg.getElement(15) & 0xFF) == 62) && (msg.getElement(14) & 0xFF) == 10 && (msg.getElement(13) & 0xFF) == 13) {
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug("Not a correctly formed message");
            }
            return true;
        }
        if (this.isConcentrator && msg.getNumDataElements() == 1 && (msg.getElement(0) & 0xFF) == 62) {
            log.debug("Init message from Concentrator: {}", (Object)msg);
            return true;
        }
        return false;
    }

    @Override
    public String toMonitorString(AbstractMRReply msg) {
        if (this.isValid(msg)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Reply from CORE-ID reader.");
            if (this.isConcentrator) {
                sb.append(" Reply from port ");
                sb.append(this.getReaderPort(msg));
            }
            sb.append(" Tag read ");
            sb.append(this.getTag(msg));
            sb.append(" checksum ");
            sb.append(this.getCheckSum(msg));
            sb.append(" valid? ");
            sb.append(this.isCheckSumValid(msg) ? "yes" : "no");
            return sb.toString();
        }
        return super.toMonitorString(msg);
    }
}

