/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.merg.concentrator;

import java.util.Locale;
import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidReply;
import jmri.jmrix.rfid.RfidSensorManager;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.TimeoutRfidSensor;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorMessage;
import jmri.jmrix.rfid.merg.concentrator.ConcentratorReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcentratorSensorManager
extends RfidSensorManager {
    private final RfidTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(ConcentratorSensorManager.class);

    public ConcentratorSensorManager(RfidSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.attach();
    }

    private void attach() {
        this.tc.addRfidListener(this);
    }

    @Override
    @Nonnull
    protected Sensor createNewSensor(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("Create new Sensor");
        TimeoutRfidSensor s = new TimeoutRfidSensor(systemName, userName);
        s.addPropertyChangeListener(this);
        return s;
    }

    @Override
    public void message(RfidMessage m) {
        if (m.toString().equals(new ConcentratorMessage(this.tc.getAdapterMemo().getProtocol().initString(), 0).toString())) {
            log.info("Sent init string: {}", (Object)m);
        } else {
            super.message(m);
        }
    }

    @Override
    public synchronized void reply(RfidReply r) {
        if (r instanceof ConcentratorReply) {
            this.processReply((ConcentratorReply)r);
        }
    }

    private void processReply(ConcentratorReply r) {
        if (!this.tc.getAdapterMemo().getProtocol().isValid(r)) {
            log.warn("Invalid message - skipping {}", (Object)r);
            return;
        }
        if (!r.isInRange()) {
            log.warn("Invalid concentrator reader range - skipping {}", (Object)r);
            return;
        }
        IdTag idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(this.tc.getAdapterMemo().getProtocol().getTag(r));
        TimeoutRfidSensor sensor = (TimeoutRfidSensor)this.provideSensor(String.valueOf(this.getSystemNamePrefix()) + r.getReaderPort());
        sensor.notify(idTag);
    }

    @Override
    public void dispose() {
        this.tc.removeRfidListener(this);
        super.dispose();
    }

    @Override
    @Nonnull
    public String validateSystemNameFormat(@Nonnull String name, @Nonnull Locale locale) throws NamedBean.BadSystemNameException {
        return this.validateTrimmedSystemNameFormat(name, locale);
    }
}

