/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.generic.standalone;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.generic.standalone.StandaloneMessage;
import jmri.jmrix.rfid.generic.standalone.StandaloneReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneTrafficController
extends RfidTrafficController {
    boolean sendInterlock = false;
    private static final Logger log = LoggerFactory.getLogger(StandaloneTrafficController.class);

    @Override
    public void sendInitString() {
        String init = this.adapterMemo.getProtocol().initString();
        if (init.length() > 0) {
            this.sendRfidMessage(new StandaloneMessage(init, 0), null);
        }
    }

    public StandaloneTrafficController(RfidSystemConnectionMemo memo) {
        this.adapterMemo = memo;
        this.logDebug = log.isDebugEnabled();
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        this.sendInterlock = ((RfidMessage)m).getInterlocked();
        super.forwardToPort(m, reply);
    }

    @Override
    public RfidMessage getRfidMessage(int length) {
        return new StandaloneMessage(length);
    }

    @Override
    protected AbstractMRReply newReply() {
        StandaloneReply reply = new StandaloneReply(this.adapterMemo.getTrafficController());
        return reply;
    }

    @Override
    public String getRange() {
        return "1";
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return this.adapterMemo.getProtocol().endOfMessage(msg);
    }
}

