/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid.generic.standalone;

import javax.annotation.Nonnull;
import jmri.IdTag;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.Reporter;
import jmri.implementation.decorators.TimeoutReporter;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidReply;
import jmri.jmrix.rfid.RfidReporter;
import jmri.jmrix.rfid.RfidReporterManager;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.generic.standalone.StandaloneMessage;
import jmri.jmrix.rfid.generic.standalone.StandaloneReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneReporterManager
extends RfidReporterManager {
    private final RfidTrafficController tc;
    private static final Logger log = LoggerFactory.getLogger(StandaloneReporterManager.class);

    public StandaloneReporterManager(RfidSystemConnectionMemo memo) {
        super(memo);
        this.tc = memo.getTrafficController();
        this.attach();
    }

    private void attach() {
        this.tc.addRfidListener(this);
    }

    @Override
    @Nonnull
    protected Reporter createNewReporter(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        log.debug("Create new Reporter: {}", (Object)systemName);
        if (!systemName.matches(String.valueOf(this.getSystemNamePrefix()) + "[" + this.tc.getRange() + "]")) {
            log.warn("Invalid Reporter name: {} - out of supported range {}", (Object)systemName, (Object)this.tc.getRange());
            throw new IllegalArgumentException("Invalid Reporter name: " + systemName + " - out of supported range " + this.tc.getRange());
        }
        TimeoutReporter r = new TimeoutReporter(new RfidReporter(systemName, userName));
        r.addPropertyChangeListener(this);
        return r;
    }

    @Override
    public void message(RfidMessage m) {
        if (m.toString().equals(new StandaloneMessage(this.tc.getAdapterMemo().getProtocol().initString(), 0).toString())) {
            log.info("Sent init string: {}", (Object)m);
        } else {
            super.message(m);
        }
    }

    @Override
    public synchronized void reply(RfidReply r) {
        if (r instanceof StandaloneReply) {
            this.processReply((StandaloneReply)r);
        }
    }

    private void processReply(StandaloneReply r) {
        if (!this.tc.getAdapterMemo().getProtocol().isValid(r)) {
            log.warn("Invalid message - skipping {}", (Object)r);
            return;
        }
        IdTag idTag = InstanceManager.getDefault(IdTagManager.class).provideIdTag(this.tc.getAdapterMemo().getProtocol().getTag(r));
        TimeoutReporter report = (TimeoutReporter)this.provideReporter(String.valueOf(this.getSystemNamePrefix()) + "1");
        report.notify(idTag);
    }
}

