/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import jmri.IdTag;
import jmri.jmrix.rfid.RfidReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class TimeoutRfidReporter
extends RfidReporter {
    private static final int TIMEOUT = 2000;
    private long whenLastReported = 0L;
    private transient TimeoutThread timeoutThread = null;
    private final boolean logDebug = log.isDebugEnabled();
    private static final Logger log = LoggerFactory.getLogger(TimeoutRfidReporter.class);

    public TimeoutRfidReporter(String systemName) {
        super(systemName);
    }

    public TimeoutRfidReporter(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public void notify(IdTag t) {
        super.notify(t);
        this.whenLastReported = System.currentTimeMillis();
        if (this.timeoutThread == null) {
            this.timeoutThread = new TimeoutThread();
            this.timeoutThread.start();
        }
    }

    private void cleanUpTimeout() {
        if (this.logDebug) {
            log.debug("Cleanup timeout thread for {}", (Object)this.mSystemName);
        }
        this.timeoutThread = null;
    }

    private class TimeoutThread
    extends Thread {
        TimeoutThread() {
            this.setName("Timeout-" + TimeoutRfidReporter.this.mSystemName);
        }

        @Override
        public void run() {
            while (TimeoutRfidReporter.this.whenLastReported + 2000L > System.currentTimeMillis()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            TimeoutRfidReporter.super.notify(null);
            if (TimeoutRfidReporter.this.logDebug) {
                log.debug("Timeout-{}", (Object)TimeoutRfidReporter.this.mSystemName);
            }
            TimeoutRfidReporter.this.cleanUpTimeout();
        }
    }
}

