/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.AbstractMRTrafficController;
import jmri.jmrix.rfid.RfidInterface;
import jmri.jmrix.rfid.RfidListener;
import jmri.jmrix.rfid.RfidMessage;
import jmri.jmrix.rfid.RfidReply;
import jmri.jmrix.rfid.RfidReporterManager;
import jmri.jmrix.rfid.RfidSensorManager;
import jmri.jmrix.rfid.RfidSystemConnectionMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RfidTrafficController
extends AbstractMRTrafficController
implements RfidInterface {
    protected RfidSystemConnectionMemo adapterMemo;
    protected boolean logDebug = log.isDebugEnabled();
    RfidSensorManager mSensorManager = null;
    RfidReporterManager mReporterManager = null;
    boolean sendInterlock = false;
    boolean expectLength = false;
    boolean countingBytes = false;
    int remainingBytes = 0;
    private static final Logger log = LoggerFactory.getLogger(RfidTrafficController.class);

    public RfidTrafficController() {
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    public void setAdapterMemo(RfidSystemConnectionMemo memo) {
        this.adapterMemo = memo;
    }

    public RfidSystemConnectionMemo getAdapterMemo() {
        return this.adapterMemo;
    }

    public RfidMessage getRfidMessage(int length) {
        return null;
    }

    @Override
    public synchronized void addRfidListener(RfidListener l) {
        this.addListener(l);
    }

    @Override
    public synchronized void removeRfidListener(RfidListener l) {
        this.removeListener(l);
    }

    @Override
    protected void forwardMessage(AbstractMRListener client, AbstractMRMessage m) {
        ((RfidListener)client).message((RfidMessage)m);
    }

    @Override
    protected void forwardReply(AbstractMRListener client, AbstractMRReply r) {
        ((RfidListener)client).reply((RfidReply)r);
    }

    public void setSensorManager(RfidSensorManager m) {
        this.mSensorManager = m;
    }

    public RfidSensorManager getSensorManager() {
        return this.mSensorManager;
    }

    public void setReporterManager(RfidReporterManager m) {
        this.mReporterManager = m;
    }

    public RfidReporterManager getReporterManager() {
        return this.mReporterManager;
    }

    @Override
    protected AbstractMRMessage pollMessage() {
        return null;
    }

    @Override
    protected AbstractMRListener pollReplyHandler() {
        return null;
    }

    @Override
    public void sendRfidMessage(RfidMessage m, RfidListener reply) {
        this.sendMessage(m, reply);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        this.sendInterlock = ((RfidMessage)m).getInterlocked();
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRMessage enterProgMode() {
        return null;
    }

    @Override
    protected AbstractMRMessage enterNormalMode() {
        return null;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        return true;
    }

    @Override
    protected AbstractMRReply newReply() {
        return null;
    }

    public abstract void sendInitString();

    public String getRange() {
        return null;
    }
}

