/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import java.util.Comparator;
import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.ReporterManager;
import jmri.SensorManager;
import jmri.jmrix.DefaultSystemConnectionMemo;
import jmri.jmrix.rfid.RfidProtocol;
import jmri.jmrix.rfid.RfidReporterManager;
import jmri.jmrix.rfid.RfidSensorManager;
import jmri.jmrix.rfid.RfidTrafficController;
import jmri.jmrix.rfid.swing.RfidComponentFactory;
import jmri.jmrix.swing.ComponentFactory;
import jmri.util.NamedBeanComparator;

public class RfidSystemConnectionMemo
extends DefaultSystemConnectionMemo {
    private RfidTrafficController rt;
    private RfidProtocol protocol;

    public RfidSystemConnectionMemo(RfidTrafficController rt) {
        this();
        this.setRfidTrafficController(rt);
    }

    public RfidSystemConnectionMemo() {
        super("F", "Rfid");
        InstanceManager.store(this, RfidSystemConnectionMemo.class);
        InstanceManager.store(new RfidComponentFactory(this), ComponentFactory.class);
    }

    public RfidTrafficController getTrafficController() {
        return this.rt;
    }

    public final void setRfidTrafficController(RfidTrafficController rt) {
        this.rt = rt;
        rt.setAdapterMemo(this);
    }

    public void configureManagers(RfidSensorManager sensorManager, RfidReporterManager reporterManager) {
        this.store(sensorManager, SensorManager.class);
        this.store(reporterManager, ReporterManager.class);
        InstanceManager.setSensorManager(sensorManager);
        InstanceManager.setReporterManager(reporterManager);
        this.register();
    }

    public RfidProtocol getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(RfidProtocol protocol) {
        this.protocol = protocol;
    }

    public RfidSensorManager getSensorManager() {
        return (RfidSensorManager)this.get(SensorManager.class);
    }

    public RfidReporterManager getReporterManager() {
        return (RfidReporterManager)this.get(ReporterManager.class);
    }

    @Override
    protected ResourceBundle getActionModelResourceBundle() {
        return ResourceBundle.getBundle("jmri.jmrix.rfid.RfidActionListBundle");
    }

    @Override
    public <B extends NamedBean> Comparator<B> getNamedBeanComparator(Class<B> type) {
        return new NamedBeanComparator();
    }

    @Override
    public void dispose() {
        this.rt = null;
        InstanceManager.deregister(this, RfidSystemConnectionMemo.class);
        this.protocol = null;
        super.dispose();
    }
}

