/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import java.util.ArrayList;
import java.util.List;
import jmri.IdTag;
import jmri.implementation.AbstractSensor;
import jmri.jmrix.rfid.RfidTagListener;

public class RfidSensor
extends AbstractSensor
implements RfidTagListener {
    ArrayList<Integer> contents = new ArrayList();

    public RfidSensor(String systemName) {
        super(systemName);
    }

    public RfidSensor(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    public void notify(IdTag r) {
        this.setOwnState(r != null ? 2 : 4);
    }

    @Override
    public void setOwnState(int state) {
        if (state == 4 && this.contents.size() > 0) {
            this.contents = new ArrayList();
        }
        super.setOwnState(state);
    }

    List<Integer> getContents() {
        return this.contents;
    }

    void notifyInRegion(Integer id) {
        if (!this.contents.contains(id)) {
            this.contents.add(id);
            this.notifyArriving(id);
        }
    }

    void notifyOutOfRegion(Integer id) {
        if (this.contents.contains(id)) {
            this.contents.remove(id);
            this.notifyLeaving(id);
        }
    }

    void notifyLeaving(Integer id) {
        this.firePropertyChange("Leaving", null, id);
    }

    void notifyArriving(Integer id) {
        this.firePropertyChange("Arriving", null, id);
    }

    @Override
    public void requestUpdateFromLayout() {
    }
}

