/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.rfid;

import jmri.jmrix.AbstractMRReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RfidProtocol {
    protected boolean isConcentrator;
    protected char concentratorFirst;
    protected char concentratorLast;
    protected int portPosition;
    private static final byte[] hexCodes = new byte[103];
    private static final Logger log;

    static {
        int i = 0;
        while (i <= 102) {
            RfidProtocol.hexCodes[i] = -1;
            ++i;
        }
        i = 48;
        while (i <= 57) {
            RfidProtocol.hexCodes[i] = (byte)(i - 48);
            ++i;
        }
        i = 65;
        while (i <= 70) {
            RfidProtocol.hexCodes[i] = (byte)(i - 65 + 10);
            ++i;
        }
        i = 97;
        while (i <= 102) {
            RfidProtocol.hexCodes[i] = (byte)(i - 97 + 10);
            ++i;
        }
        log = LoggerFactory.getLogger(RfidProtocol.class);
    }

    public RfidProtocol() {
        this('\u0000', '\u0000', 0);
    }

    public RfidProtocol(char concentratorFirst, char concentratorLast, int portPosition) {
        this.isConcentrator = concentratorFirst != '\u0000' && concentratorLast != '\u0000' && portPosition != 0;
        this.concentratorFirst = concentratorFirst;
        this.concentratorLast = concentratorLast;
        this.portPosition = portPosition - 1;
    }

    public String getTag(AbstractMRReply msg) {
        log.error("getTag should not be called");
        return String.valueOf(msg.getElement(0));
    }

    public boolean providesChecksum() {
        return false;
    }

    public abstract String getCheckSum(AbstractMRReply var1);

    public abstract boolean isValid(AbstractMRReply var1);

    public abstract boolean endOfMessage(AbstractMRReply var1);

    public abstract String initString();

    public char getReaderPort(AbstractMRReply msg) {
        Character p;
        if (this.isConcentrator && (p = Character.valueOf((char)msg.getElement(this.portPosition))).toString().matches("[" + this.concentratorFirst + "-" + this.concentratorLast + "]")) {
            return p.charValue();
        }
        return '\u0000';
    }

    public String toMonitorString(AbstractMRReply msg) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unknown reply of length ");
        sb.append(msg.getNumDataElements());
        sb.append(": ");
        sb.append(msg.toString()).append("\n");
        sb.append("\n");
        return sb.toString();
    }

    private static int charToNibble(char c) {
        if (c > 'f') {
            throw new IllegalArgumentException("Invalid hex character: " + c);
        }
        byte nibble = hexCodes[c];
        if (nibble < 0) {
            throw new IllegalArgumentException("Invalid hex character: " + c);
        }
        return nibble;
    }

    protected static byte[] convertHexString(String s) {
        int stringLength = s.length();
        if ((stringLength & 1) != 0) {
            throw new IllegalArgumentException("convertHexString requires an even number of hex characters");
        }
        byte[] bytes = new byte[stringLength / 2];
        int i = 0;
        int j = 0;
        while (i < stringLength) {
            int high = RfidProtocol.charToNibble(s.charAt(i));
            int low = RfidProtocol.charToNibble(s.charAt(i + 1));
            bytes[j] = (byte)(high << 4 | low);
            i += 2;
            ++j;
        }
        return bytes;
    }
}

