/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.qsi.packetgen;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jmri.jmrix.qsi.QsiListener;
import jmri.jmrix.qsi.QsiMessage;
import jmri.jmrix.qsi.QsiReply;
import jmri.jmrix.qsi.QsiSystemConnectionMemo;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;

public class PacketGenFrame
extends JmriJFrame
implements QsiListener {
    private QsiSystemConnectionMemo _memo = null;
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);

    public PacketGenFrame(QsiSystemConnectionMemo memo) {
        this._memo = memo;
    }

    @Override
    public void initComponents() {
        this.jLabel1.setText("Command:");
        this.jLabel1.setVisible(true);
        this.sendButton.setText("Send");
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText("Send packet");
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText("Enter command as hex string");
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setTitle("Send QSI command");
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.packetTextField);
        this.getContentPane().add(this.sendButton);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PacketGenFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.pack();
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this._memo.getQsiTrafficController().sendQsiMessage(this.createPacket(input), this);
    }

    QsiMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        if (b.length == 0) {
            return null;
        }
        QsiMessage m = new QsiMessage(b.length);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        return m;
    }

    @Override
    public void message(QsiMessage m) {
    }

    @Override
    public void reply(QsiReply r) {
    }
}

