/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.qsi;

import jmri.InstanceManager;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractMessage;
import jmri.jmrix.qsi.QsiSystemConnectionMemo;
import jmri.jmrix.qsi.QsiTrafficController;
import jmri.util.StringUtil;

public class QsiMessage
extends AbstractMessage {
    public static final int STX = 15;
    public static final int DLE = 5;
    public static final int ETX = 4;
    public static final int CR = 13;
    public static final int LF = 10;
    public static final int RD_VER = 0;
    public static final int WT_FLASH = 2;
    public static final int ER_FLASH = 3;
    public static final int WT_EEDATA = 5;
    static final int MAXSIZE = 515;

    public QsiMessage(int i) {
        super(i);
    }

    public QsiMessage(String s) {
        super(s);
    }

    public QsiMessage(QsiMessage m) {
        super(m);
    }

    public void setOpCode(int i) {
        this._dataChars[0] = i;
    }

    public int getOpCode() {
        return this._dataChars[0];
    }

    public String getOpCodeHex() {
        return "0x" + Integer.toHexString(this.getOpCode());
    }

    public void setLength(int i) {
        this._dataChars[1] = i;
    }

    public void setV4Length(int i) {
        this._dataChars[0] = this.hexDigit((i & 0xF0) >> 4);
        this._dataChars[1] = this.hexDigit(i & 0xF);
    }

    public void setAddress(int i) {
        this._dataChars[2] = i & 0xFF;
        this._dataChars[3] = i >> 8 & 0xFF;
        this._dataChars[4] = i >> 16;
    }

    public void setV4Address(int i) {
        this._dataChars[2] = this.hexDigit((i & 0xF000) >> 12);
        this._dataChars[3] = this.hexDigit((i & 0xF00) >> 8);
        this._dataChars[4] = this.hexDigit((i & 0xF0) >> 4);
        this._dataChars[5] = this.hexDigit(i & 0xF);
    }

    public void setV4RecType(int i) {
        this._dataChars[6] = this.hexDigit((i & 0xF0) >> 4);
        this._dataChars[7] = this.hexDigit(i & 0xF);
    }

    public void setData(int[] d) {
        System.arraycopy(d, 0, this._dataChars, 5, d.length);
    }

    public void setV4Data(int[] d) {
        int j = 8;
        int i = 0;
        while (i < d.length) {
            this._dataChars[j++] = this.hexDigit((d[i] & 0xF0) >> 4);
            this._dataChars[j++] = this.hexDigit(d[i] & 0xF);
            ++i;
        }
    }

    public void setChecksum() {
        int checksum = 0;
        int i = 0;
        while (i < this._nDataChars - 1) {
            checksum += this._dataChars[i];
            ++i;
        }
        if ((checksum &= 0xFF) > 0) {
            checksum = 256 - checksum;
        }
        this._dataChars[this._nDataChars - 1] = checksum;
    }

    public void setV4Checksum(int length, int addr, int type, int[] data) {
        int checksum = length + ((addr & 0xFF00) >> 8) + (addr & 0xFF) + type;
        int i = 0;
        while (i < data.length) {
            checksum += data[i];
            ++i;
        }
        if ((checksum &= 0xFF) > 0) {
            checksum = 256 - checksum;
        }
        this._dataChars[this._nDataChars - 2] = this.hexDigit((checksum & 0xF0) >> 4);
        this._dataChars[this._nDataChars - 1] = this.hexDigit(checksum & 0xF);
    }

    private int hexDigit(int b) {
        if (b > 9) {
            return b - 9 + 64;
        }
        return b + 48;
    }

    public QsiMessage frame() {
        int j = 2;
        QsiMessage f = new QsiMessage(515);
        f.setElement(0, 15);
        f.setElement(1, 15);
        int i = 0;
        while (i < this._nDataChars) {
            if (this._dataChars[i] == 15 || this._dataChars[i] == 4 || this._dataChars[i] == 5) {
                f.setElement(j++, 5);
            }
            f.setElement(j++, this._dataChars[i]);
            ++i;
        }
        f.setElement(j++, 4);
        f._nDataChars = j;
        return f;
    }

    public QsiMessage v4frame() {
        QsiMessage f = new QsiMessage(515);
        f.setElement(0, 58);
        int i = 1;
        while (i <= this._nDataChars) {
            f.setElement(i, this._dataChars[i - 1]);
            ++i;
        }
        f.setElement(i++, 13);
        f.setElement(i++, 10);
        f._nDataChars = i;
        return f;
    }

    @Override
    public String toString() {
        QsiSystemConnectionMemo memo = InstanceManager.getDefault(QsiSystemConnectionMemo.class);
        return this.toString(memo.getQsiTrafficController());
    }

    public String toString(QsiTrafficController controller) {
        if (this._dataChars == null) {
            return "<none>";
        }
        StringBuilder s = new StringBuilder("");
        if (controller == null || controller.isSIIBootMode()) {
            int i = 0;
            while (i < this._nDataChars) {
                s.append(StringUtil.twoHexFromInt(this._dataChars[i])).append(" ");
                ++i;
            }
        } else {
            int i = 0;
            while (i < this._nDataChars) {
                s.append("<").append(this._dataChars[i]).append(">");
                ++i;
            }
        }
        return s.toString();
    }

    public boolean isKillMain() {
        return this.getOpCode() == 45;
    }

    public boolean isEnableMain() {
        return this.getOpCode() == 43;
    }

    public static QsiMessage getEnableMain() {
        QsiMessage m = new QsiMessage(1);
        m.setOpCode(43);
        return m;
    }

    public static QsiMessage getKillMain() {
        QsiMessage m = new QsiMessage(1);
        m.setOpCode(45);
        return m;
    }

    public static QsiMessage getProgMode() {
        QsiMessage m = new QsiMessage(1);
        m.setOpCode(80);
        return m;
    }

    public static QsiMessage getExitProgMode() {
        QsiMessage m = new QsiMessage(1);
        m.setOpCode(32);
        return m;
    }

    public static QsiMessage getClearStatus() {
        QsiMessage m = new QsiMessage(3);
        m.setElement(0, 17);
        m.setElement(1, 0);
        m.setElement(2, 0);
        return m;
    }

    public static QsiMessage getReadCV(int cv, ProgrammingMode mode) {
        QsiMessage m = new QsiMessage(4);
        m.setElement(0, 9);
        m.setElement(1, 1);
        m.setElement(2, 0);
        m.setElement(3, cv);
        return m;
    }

    public static QsiMessage getWriteCV(int cv, int val, ProgrammingMode mode) {
        QsiMessage m = new QsiMessage(5);
        m.setElement(0, 30);
        m.setElement(1, 2);
        m.setElement(2, 0);
        m.setElement(3, cv);
        m.setElement(4, val);
        return m;
    }

    public static QsiMessage getReadRegister(int reg) {
        QsiMessage m = new QsiMessage(1);
        m.setOpCode(32);
        return m;
    }

    public static QsiMessage getWriteRegister(int reg, int val) {
        QsiMessage m = new QsiMessage(1);
        m.setOpCode(32);
        return m;
    }

    public static QsiMessage getReadBootVersion() {
        QsiMessage m = new QsiMessage(3);
        m.setOpCode(0);
        m.setLength(2);
        m.setChecksum();
        return m.frame();
    }

    public static QsiMessage getWriteFlash(int addr, int[] data) {
        int l = data.length;
        if (l % 8 != 0) {
            l += 8 - l % 8;
        }
        int[] padded = new int[l];
        int i = 0;
        while (i < l) {
            padded[i] = i < data.length ? data[i] : 255;
            ++i;
        }
        QsiMessage m = new QsiMessage(6 + l);
        m.setOpCode(2);
        m.setLength(l / 8);
        m.setAddress(addr);
        m.setData(padded);
        m.setChecksum();
        return m.frame();
    }

    public static QsiMessage getV4WriteFlash(int addr, int[] data, int type) {
        int l = (data.length + 5) * 2;
        QsiMessage m = new QsiMessage(l);
        m.setV4Length(data.length);
        m.setV4Address(addr);
        m.setV4RecType(type);
        m.setV4Data(data);
        m.setV4Checksum(data.length, addr, type, data);
        return m.v4frame();
    }

    public static QsiMessage getV4EndOfFile() {
        int l = 10;
        QsiMessage m = new QsiMessage(l);
        m.setV4Length(0);
        m.setV4Address(0);
        m.setV4RecType(1);
        m.setV4Checksum(0, 0, 1, new int[0]);
        return m.v4frame();
    }

    public static QsiMessage getv4ExtAddr() {
        int l = 14;
        int[] data = new int[2];
        QsiMessage m = new QsiMessage(l);
        m.setV4Length(2);
        m.setV4Address(0);
        m.setV4RecType(4);
        m.setV4Data(data);
        m.setV4Checksum(0, 0, 4, data);
        return m.v4frame();
    }

    public static QsiMessage getEraseFlash(int addr, int rows) {
        QsiMessage m = new QsiMessage(6);
        m.setOpCode(3);
        m.setLength(rows);
        m.setAddress(addr);
        m.setChecksum();
        return m.frame();
    }

    public static QsiMessage getWriteEE(int addr, int[] data) {
        QsiMessage m = new QsiMessage(6 + data.length);
        m.setOpCode(5);
        m.setLength(data.length);
        m.setAddress(addr & 0xFF);
        m.setData(data);
        m.setChecksum();
        return m.frame();
    }

    public static QsiMessage getReset() {
        QsiMessage m = new QsiMessage(3);
        m.setOpCode(0);
        m.setLength(0);
        m.setChecksum();
        return m.frame();
    }
}

