/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pricom.pockettester;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jmri.jmrix.pricom.pockettester.Bundle;
import jmri.jmrix.pricom.pockettester.DataSource;
import jmri.jmrix.pricom.pockettester.MonitorFrame;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketDataModel
extends AbstractTableModel {
    public static final int ADDRESSCOLUMN = 0;
    public static final int TYPECOLUMN = 1;
    public static final int DETAILCOLUMN = 2;
    public static final int MONITORBUTTONCOLUMN = 3;
    public static final int NUMCOLUMN = 4;
    static final Boolean True = true;
    static final Boolean False = false;
    DataSource source;
    Vector<String> keys = new Vector();
    Vector<String> addresses = new Vector();
    Vector<String> types = new Vector();
    Vector<String> details = new Vector();
    private static final Logger log = LoggerFactory.getLogger(PacketDataModel.class);

    @Override
    public int getRowCount() {
        return this.keys.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("ColumnAddress");
            }
            case 1: {
                return Bundle.getMessage("ColumnType");
            }
            case 2: {
                return Bundle.getMessage("ColumnDetails");
            }
            case 3: {
                return "";
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: 
            case 2: {
                return String.class;
            }
            case 3: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.addresses.elementAt(row);
            }
            case 1: {
                return this.types.elementAt(row);
            }
            case 2: {
                return this.details.elementAt(row);
            }
            case 3: {
                return Bundle.getMessage("ButtonTrace");
            }
        }
        log.error("internal state inconsistent with table request for {} {}", (Object)row, (Object)col);
        return null;
    }

    @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
    public int getPreferredWidth(int col) {
        switch (col) {
            case 0: {
                return new JTextField((int)8).getPreferredSize().width;
            }
            case 1: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 2: {
                return new JTextField((int)12).getPreferredSize().width;
            }
            case 3: {
                return new JButton((String)"Details").getPreferredSize().width;
            }
        }
        return new JLabel((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 3: {
                MonitorFrame f = new MonitorFrame();
                try {
                    f.initComponents();
                    f.setFilter((String)this.getValueAt(row, 0));
                    this.source.addListener(f);
                }
                catch (Exception ex) {
                    log.error("starting MonitorFrame caught exception: {}", (Object)ex.toString());
                }
                f.setVisible(true);
                return;
            }
        }
    }

    public void configureTable(JTable slotTable) {
        slotTable.getTableHeader().setReorderingAllowed(true);
        slotTable.setAutoResizeMode(0);
        int i = 0;
        while (i < slotTable.getColumnCount()) {
            int width = this.getPreferredWidth(i);
            slotTable.getColumnModel().getColumn(i).setPreferredWidth(width);
            ++i;
        }
        slotTable.sizeColumnsToFit(-1);
        this.setColumnToHoldButton(slotTable, 3);
    }

    void setColumnToHoldButton(JTable slotTable, int column) {
        TableColumnModel tcm = slotTable.getColumnModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        tcm.getColumn(column).setCellRenderer(buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(column).setCellEditor(buttonEditor);
        slotTable.setRowHeight(new JButton((String)new StringBuilder((String)"  ").append((Object)this.getValueAt((int)1, (int)column)).toString()).getPreferredSize().height);
        slotTable.getColumnModel().getColumn(column).setPreferredWidth(new JButton((String)new StringBuilder((String)"  ").append((Object)this.getValueAt((int)1, (int)column)).toString()).getPreferredSize().width);
    }

    public void dispose() {
    }

    public void asciiFormattedMessage(String m) {
        String key = this.getKey(m);
        if (key == null) {
            return;
        }
        String address = this.getPrefix(m);
        String type = this.getType(m);
        String detail = this.getDetails(m);
        int index = this.keys.indexOf(key);
        if (index == -1) {
            this.keys.addElement(key);
            this.addresses.addElement(address);
            this.types.addElement(type);
            this.details.addElement(detail);
            index = this.keys.indexOf(key);
            this.fireTableRowsInserted(index, index);
        } else {
            this.keys.setElementAt(key, index);
            this.addresses.setElementAt(address, index);
            this.types.setElementAt(type, index);
            this.details.setElementAt(detail, index);
            this.fireTableRowsUpdated(index, index);
        }
    }

    public void setSource(DataSource d) {
        this.source = d;
    }

    public void reset() {
        int count = this.keys.size();
        this.keys = new Vector();
        this.addresses = new Vector();
        this.types = new Vector();
        this.details = new Vector();
        this.fireTableRowsDeleted(0, count - 1);
    }

    String getKey(String s) {
        if (!s.startsWith("ADR=")) {
            return null;
        }
        return s.substring(0, 22);
    }

    String getPrefix(String s) {
        return s.substring(0, 8);
    }

    String getType(String s) {
        return s.substring(9, 22);
    }

    String getDetails(String s) {
        return s.substring(23, s.length() - 1);
    }
}

