/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.pricom.downloader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdiFile {
    File file;
    private InputStream buffIn;
    String comment = "";
    int commentLength;
    int lastAddress;
    int address;
    int fileLength;
    private static final Logger log = LoggerFactory.getLogger(PdiFile.class);

    public PdiFile(File file) {
        this.file = file;
    }

    public void open() throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(this.file));
        this.open(stream);
    }

    public void open(InputStream stream) throws IOException {
        this.buffIn = stream;
        int high = this.buffIn.read() & 0xFF;
        int low = this.buffIn.read() & 0xFF;
        this.commentLength = high * 256 + low;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.commentLength - 2) {
            int next = this.buffIn.read();
            if (next == 13) {
                buffer.append("\n");
            } else if (next != 10) {
                buffer.append((char)next);
            }
            ++i;
        }
        this.comment = buffer.toString();
        high = this.buffIn.read() & 0xFF;
        low = this.buffIn.read() & 0xFF;
        this.address = high * 256 + low;
        if (log.isDebugEnabled()) {
            log.debug("address {} {}", (Object)high, (Object)low);
        }
        high = this.buffIn.read() & 0xFF;
        low = this.buffIn.read() & 0xFF;
        this.lastAddress = high * 256 + low;
        if (log.isDebugEnabled()) {
            log.debug("length {} {}", (Object)high, (Object)low);
        }
        this.fileLength = (int)this.file.length() - 6 - this.commentLength;
        if (log.isDebugEnabled()) {
            log.debug("lengths: file {}, comment {}, data {}", new Object[]{(int)this.file.length(), this.commentLength, this.lastAddress});
        }
    }

    public String getComment() {
        return this.comment;
    }

    int length() {
        return this.fileLength;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="API defined by Pricom docs")
    public byte[] getNext(int n) {
        byte[] buffer = new byte[n + 3 + 2];
        buffer[0] = n == 128 ? 60 : 59;
        buffer[1] = (byte)(this.address >> 8 & 0xFF);
        buffer[2] = (byte)(this.address & 0xFF);
        this.address += n;
        int i = 0;
        while (i < n + 2) {
            buffer[3 + i] = 0;
            ++i;
        }
        try {
            i = 0;
            while (true) {
                if (i >= n) {
                    return buffer;
                }
                int rd = this.buffIn.read();
                if (rd == -1) {
                    return null;
                }
                buffer[3 + i] = (byte)(rd & 0xFF);
                ++i;
            }
        }
        catch (IOException e) {
            log.error("IO exception reading file: {}", (Throwable)e);
        }
        return buffer;
    }
}

