/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.swing.packetgen;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.swing.packetgen.Bundle;
import jmri.util.JmriJFrame;
import jmri.util.StringUtil;

public class SerialPacketGenFrame
extends JmriJFrame
implements SerialListener {
    JLabel jLabel1 = new JLabel();
    JButton sendButton = new JButton();
    JTextField packetTextField = new JTextField(12);
    JCheckBox interlockButton = new JCheckBox(Bundle.getMessage("InterlockBoxLabel"));
    SerialTrafficController tc = null;

    public SerialPacketGenFrame(SerialTrafficController tc) {
        this.tc = tc;
    }

    @Override
    public void initComponents() {
        this.jLabel1.setText(Bundle.getMessage("CommandLabel"));
        this.jLabel1.setVisible(true);
        this.sendButton.setText(Bundle.getMessage("ButtonSend"));
        this.sendButton.setVisible(true);
        this.sendButton.setToolTipText(Bundle.getMessage("TooltipSendPacket"));
        this.packetTextField.setText("");
        this.packetTextField.setToolTipText(Bundle.getMessage("EnterHexToolTip"));
        this.packetTextField.setMaximumSize(new Dimension(this.packetTextField.getMaximumSize().width, this.packetTextField.getPreferredSize().height));
        this.setTitle(Bundle.getMessage("SendPacketTitle"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(this.jLabel1);
        this.getContentPane().add(this.packetTextField);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.interlockButton);
        p2.add(this.sendButton);
        this.getContentPane().add(p2);
        this.sendButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialPacketGenFrame.this.sendButtonActionPerformed(e);
            }
        });
        this.getContentPane().add(new JSeparator(0));
        this.pack();
    }

    public void sendButtonActionPerformed(ActionEvent e) {
        String input = this.packetTextField.getText();
        this.tc.sendSerialMessage(this.createPacket(input), this);
    }

    SerialMessage createPacket(String s) {
        byte[] b = StringUtil.bytesFromHexString(s);
        SerialMessage m = this.tc.getSerialMessage(b.length);
        int i = 0;
        while (i < b.length) {
            m.setElement(i, b[i]);
            ++i;
        }
        m.setInterlocked(this.interlockButton.isSelected());
        return m;
    }

    @Override
    public void message(SerialMessage m) {
    }

    @Override
    public void reply(SerialReply r) {
    }
}

