/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.simulator;

import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSensorManager;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import jmri.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificSensorManager
extends SerialSensorManager {
    SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SpecificSensorManager.class);

    public SpecificSensorManager(SerialTrafficController tc) {
        super(tc);
        this.tc = tc;
    }

    @Override
    public synchronized void reply(SerialReply r) {
        this.processForPollReq(r);
    }

    private void processForPollReq(SerialReply l) {
        if ((l.getElement(0) & 0xFF) == 2) {
            if ((l.getElement(1) & 0xFF) == 82 && l.getNumDataElements() == 4) {
                int dat = l.getElement(2) & 0xFF;
                int flag = l.getElement(3) & 0xFF;
                String newHouseCode = X10Sequence.houseValueToText(X10Sequence.decode(dat >> 4 & 0xF));
                int newCmdCode = dat & 0xF;
                int newAddrCode = -1;
                Sensor sensor = null;
                if ((flag & 0x80) == 128) {
                    if (newCmdCode == 6 || newCmdCode == 0 || newCmdCode == 1) {
                        this.getNamedBeanSet().forEach(sensorInSet -> {
                            String sName = sensorInSet.getSystemName();
                            if (newHouseCode.compareTo(this.tc.getAdapterMemo().getSerialAddress().houseCodeFromSystemName(sName)) == 0) {
                                try {
                                    if (newCmdCode == 6 || newCmdCode == 0) {
                                        sensorInSet.setKnownState(4);
                                    } else {
                                        sensorInSet.setKnownState(2);
                                    }
                                }
                                catch (JmriException e) {
                                    if (newCmdCode == 6 || newCmdCode == 0) {
                                        log.error("Exception setting {} sensor INACTIVE: {}", (Object)sName, (Object)e);
                                    }
                                    log.error("Exception setting {} sensor ACTIVE: {}", (Object)sName, (Object)e);
                                }
                            }
                        });
                    } else if (newHouseCode != null && newAddrCode > 0) {
                        String sysName = String.valueOf(this.getSystemPrefix()) + "S" + newHouseCode + newAddrCode;
                        sensor = this.provideSensor(sysName);
                        if (newCmdCode == 2 || newCmdCode == 5 || newCmdCode == 13) {
                            try {
                                sensor.setKnownState(2);
                            }
                            catch (JmriException e) {
                                log.error("Exception setting {} sensor ACTIVE: {}", (Object)sysName, (Object)e);
                            }
                        }
                        if (newCmdCode == 3 || newCmdCode == 4 || newCmdCode == 14) {
                            try {
                                sensor.setKnownState(4);
                            }
                            catch (JmriException e) {
                                log.error("Exception setting {} sensor INACTIVE: {}", (Object)sysName, (Object)e);
                            }
                        }
                    }
                }
            } else if ((l.getElement(1) & 0xFF) == 80 && l.getNumDataElements() == 11) {
                int highAddr = l.getElement(5) & 0xFF;
                int middleAddr = l.getElement(6) & 0xFF;
                int lowAddr = l.getElement(7) & 0xFF;
                int cmd1 = l.getElement(9) & 0xFF;
                StringBuilder sysName = new StringBuilder();
                sysName.append(this.getSystemPrefix());
                sysName.append("S");
                sysName.append(StringUtil.twoHexFromInt(highAddr));
                sysName.append(".");
                sysName.append(StringUtil.twoHexFromInt(middleAddr));
                sysName.append(".");
                sysName.append(StringUtil.twoHexFromInt(lowAddr));
                Sensor sensor = null;
                try {
                    sensor = this.provideSensor(new String(sysName));
                }
                catch (IllegalArgumentException iae) {
                    log.debug("Attempt access sensor {} failed", (Object)sysName);
                    throw iae;
                }
                if (cmd1 == 18 || cmd1 == 17) {
                    try {
                        sensor.setKnownState(2);
                    }
                    catch (JmriException e) {
                        log.error("Exception setting {} sensor ACTIVE: {}", (Object)sysName, (Object)e);
                    }
                }
                if (cmd1 == 20 || cmd1 == 19) {
                    try {
                        sensor.setKnownState(4);
                    }
                    catch (JmriException e) {
                        log.error("Exception setting {} sensor INACTIVE: {}", (Object)sysName, (Object)e);
                    }
                }
            }
        }
    }
}

