/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.simulator;

import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import jmri.util.StringUtil;

public class SpecificReply
extends SerialReply {
    public SpecificReply(SerialTrafficController tc) {
        super(tc);
        this.setBinary(true);
    }

    public SpecificReply(String s, SerialTrafficController tc) {
        super(tc, s);
        this.setBinary(true);
    }

    @Override
    public String toMonitorString() {
        int len = this.getNumDataElements();
        StringBuilder text = new StringBuilder();
        if ((this.getElement(0) & 0xFF) != 2) {
            text.append("INVALID HEADER: " + String.format("0x%1X", this.getElement(0) & 0xFF));
            text.append(" len: " + len);
        } else {
            switch (this.getElement(1) & 0xFF) {
                case 98: {
                    text.append("Send Cmd ");
                    if (len == 8 || len == 22) {
                        if ((this.getElement(5) & 0x10) == 0) {
                            text.append(" Std");
                        } else if (len == 22) {
                            text.append(" Ext");
                        }
                        text.append(" addr " + String.format("%1$X.%2$X.%3$X", this.getElement(2) & 0xFF, this.getElement(3) & 0xFF, this.getElement(4) & 0xFF));
                        switch (this.getElement(6) & 0xFF) {
                            case 18: {
                                text.append(" ON FAST ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break;
                            }
                            case 17: {
                                text.append(" ON RAMP ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break;
                            }
                            case 20: {
                                text.append(" OFF FAST ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break;
                            }
                            case 19: {
                                text.append(" OFF RAMP ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break;
                            }
                            case 33: {
                                text.append(" CHG ");
                                text.append((double)(this.getElement(7) & 0xFF) / 256.0);
                                break;
                            }
                            default: {
                                text.append(" Unknown cmd: " + StringUtil.twoHexFromInt(this.getElement(6) & 0xFF));
                            }
                        }
                        if ((this.getElement(8) & 0xFF) != 21) break;
                        text.append(" NAK - command not processed");
                        break;
                    }
                    text.append(" !! Length wrong: " + len);
                    break;
                }
                case 84: {
                    text.append("Poll Button ");
                    int button = ((this.getElement(2) & 0xF0) >> 4) + 1;
                    text.append(button);
                    int op = this.getElement(2) & 0xF;
                    if (op == 3) {
                        text.append(" HELD");
                        break;
                    }
                    if (op == 4) {
                        text.append(" RELEASED");
                        break;
                    }
                    if (op != 2) break;
                    text.append(" TAP");
                    break;
                }
                case 85: {
                    text.append("Reset by Button at Power Cycle");
                    break;
                }
                case 99: {
                    text.append("Send Cmd X10 ");
                    if ((this.getElement(3) & 0x80) == 128) {
                        text.append(X10Sequence.formatCommandByte(this.getElement(2) & 0xFF));
                    } else {
                        text.append(X10Sequence.formatAddressByte(this.getElement(2) & 0xFF));
                    }
                    if ((this.getElement(4) & 0xFF) != 21) break;
                    text.append(" NAK - command not processed");
                    break;
                }
                case 82: {
                    text.append("Poll Cmd X10 ");
                    if ((this.getElement(3) & 0x80) == 128) {
                        text.append(X10Sequence.formatCommandByte(this.getElement(2) & 0xFF));
                        break;
                    }
                    text.append(X10Sequence.formatAddressByte(this.getElement(2) & 0xFF));
                    break;
                }
                default: {
                    text.append(" Unknown command: " + StringUtil.twoHexFromInt(this.getElement(1) & 0xFF));
                    text.append(" len: " + len);
                }
            }
        }
        return text + "\n";
    }
}

