/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.simulator;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import jmri.jmrix.powerline.SerialAddress;
import jmri.jmrix.powerline.SerialPortController;
import jmri.jmrix.powerline.simulator.SpecificSystemConnectionMemo;
import jmri.jmrix.powerline.simulator.SpecificTrafficController;
import jmri.util.ImmediatePipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulatorAdapter
extends SerialPortController
implements Runnable {
    private boolean opened = false;
    private Thread sourceThread;
    private DataOutputStream pout = null;
    private DataInputStream pin = null;
    private static final Logger log = LoggerFactory.getLogger(SimulatorAdapter.class);

    public SimulatorAdapter() {
        super(new SpecificSystemConnectionMemo());
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            ImmediatePipedOutputStream tempPipeI = new ImmediatePipedOutputStream();
            this.pout = new DataOutputStream(tempPipeI);
            ImmediatePipedOutputStream tempPipeO = new ImmediatePipedOutputStream();
            this.pin = new DataInputStream(new PipedInputStream(tempPipeO));
        }
        catch (IOException e) {
            log.error("init (pipe): Exception: {}", (Object)e.toString());
        }
        this.opened = true;
        return null;
    }

    @Override
    public void configure() {
        SpecificTrafficController tc = new SpecificTrafficController(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setSerialAddress(new SerialAddress(this.getSystemConnectionMemo()));
        this.sourceThread = new Thread(this);
        this.sourceThread.setName("Powerline Simulator");
        this.sourceThread.setPriority(1);
        this.sourceThread.start();
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened || this.pin == null) {
            log.error("getInputStream called before load(), stream not available");
        }
        return this.pin;
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened || this.pout == null) {
            log.error("getOutputStream called before load(), stream not available");
        }
        return this.pout;
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    @Override
    public String[] validBaudRates() {
        log.debug("validBaudRates should not have been invoked");
        return new String[0];
    }

    @Override
    public int[] validBaudNumbers() {
        return new int[0];
    }

    @Override
    public String getCurrentBaudRate() {
        return "";
    }

    @Override
    public String getCurrentPortName() {
        return "";
    }

    @Override
    public void run() {
        if (log.isInfoEnabled()) {
            log.info("Powerline Simulator Started");
        }
    }
}

