/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.serialdriver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import jmri.jmrix.AbstractPortController;
import jmri.jmrix.powerline.SerialAddress;
import jmri.jmrix.powerline.SerialPortController;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.cp290.SpecificSystemConnectionMemo;
import jmri.jmrix.powerline.insteon2412s.SpecificTrafficController;
import jmri.jmrix.powerline.serialdriver.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import purejavacomm.CommPortIdentifier;
import purejavacomm.NoSuchPortException;
import purejavacomm.PortInUseException;
import purejavacomm.SerialPort;
import purejavacomm.UnsupportedCommOperationException;

public class SerialDriverAdapter
extends SerialPortController {
    SerialPort activeSerialPort = null;
    String[] stdOption1Values = new String[]{"CM11", "CP290", "Insteon 2412S"};
    protected String[] validSpeeds = new String[]{Bundle.getMessage("BaudAutomatic")};
    protected int[] validSpeedValues = new int[]{4800};
    private boolean opened = false;
    InputStream serialStream = null;
    private static final Logger log = LoggerFactory.getLogger(SerialDriverAdapter.class);

    public SerialDriverAdapter() {
        super(new SerialSystemConnectionMemo());
        this.option1Name = "Adapter";
        this.options.put(this.option1Name, new AbstractPortController.Option("Adapter", this.stdOption1Values));
        this.manufacturerName = "Powerline";
    }

    @Override
    public String openPort(String portName, String appName) {
        try {
            CommPortIdentifier portID = CommPortIdentifier.getPortIdentifier(portName);
            try {
                this.activeSerialPort = (SerialPort)portID.open(appName, 2000);
            }
            catch (PortInUseException p) {
                return this.handlePortBusy(p, portName, log);
            }
            try {
                this.setSerialPort();
            }
            catch (UnsupportedCommOperationException e) {
                log.error("Cannot set serial parameters on port {}: {}", (Object)portName, (Object)e.getMessage());
                return "Cannot set serial parameters on port " + portName + ": " + e.getMessage();
            }
            try {
                log.debug("Serial framing was observed as: {} {}", (Object)this.activeSerialPort.isReceiveFramingEnabled(), (Object)this.activeSerialPort.getReceiveFramingByte());
            }
            catch (Exception ef) {
                log.debug("failed to set serial framing: ", (Throwable)ef);
            }
            try {
                this.activeSerialPort.enableReceiveTimeout(10);
                log.debug("Serial timeout was observed as: {} {}", (Object)this.activeSerialPort.getReceiveTimeout(), (Object)this.activeSerialPort.isReceiveTimeoutEnabled());
            }
            catch (Exception et) {
                log.info("failed to set serial timeout: ", (Throwable)et);
            }
            this.serialStream = this.activeSerialPort.getInputStream();
            this.purgeStream(this.serialStream);
            if (log.isInfoEnabled()) {
                log.info("{} port opened at {} baud with DTR: {} RTS: {} DSR: {} CTS: {}  CD: {}", new Object[]{portName, this.activeSerialPort.getBaudRate(), this.activeSerialPort.isDTR(), this.activeSerialPort.isRTS(), this.activeSerialPort.isDSR(), this.activeSerialPort.isCTS(), this.activeSerialPort.isCD()});
            }
            if (log.isDebugEnabled()) {
                log.debug(" port flow control shows {}", (Object)(this.activeSerialPort.getFlowControlMode() == 2 ? "hardware flow control" : "no flow control"));
                this.setPortEventLogging(this.activeSerialPort);
            }
            this.opened = true;
        }
        catch (NoSuchPortException p) {
            return this.handlePortNotFound(p, portName, log);
        }
        catch (IOException ex) {
            log.error("Unexpected exception while opening port {} ", (Object)portName, (Object)ex);
            return "Unexpected error while opening port " + portName + ": " + ex;
        }
        return null;
    }

    public boolean okToSend() {
        return true;
    }

    @Override
    public void configure() {
        SerialTrafficController tc = null;
        String opt1 = this.getOptionState(this.option1Name);
        if (opt1.equals("CM11")) {
            this.setSystemConnectionMemo(new jmri.jmrix.powerline.cm11.SpecificSystemConnectionMemo());
            tc = new jmri.jmrix.powerline.cm11.SpecificTrafficController(this.getSystemConnectionMemo());
        } else if (opt1.equals("CP290")) {
            this.setSystemConnectionMemo(new SpecificSystemConnectionMemo());
            tc = new jmri.jmrix.powerline.cp290.SpecificTrafficController(this.getSystemConnectionMemo());
        } else if (opt1.equals("Insteon 2412S")) {
            this.setSystemConnectionMemo(new jmri.jmrix.powerline.insteon2412s.SpecificSystemConnectionMemo());
            tc = new SpecificTrafficController(this.getSystemConnectionMemo());
        } else {
            log.warn("protocol option {} defaults to CM11", (Object)opt1);
            this.setSystemConnectionMemo(new jmri.jmrix.powerline.cm11.SpecificSystemConnectionMemo());
            tc = new jmri.jmrix.powerline.cm11.SpecificTrafficController(this.getSystemConnectionMemo());
        }
        this.getSystemConnectionMemo().setTrafficController(tc);
        tc.setAdapterMemo(this.getSystemConnectionMemo());
        this.getSystemConnectionMemo().configureManagers();
        tc.connectPort(this);
        this.getSystemConnectionMemo().setSerialAddress(new SerialAddress(this.getSystemConnectionMemo()));
    }

    @Override
    public DataInputStream getInputStream() {
        if (!this.opened) {
            log.error("getInputStream called before load(), stream not available");
            return null;
        }
        return new DataInputStream(this.serialStream);
    }

    @Override
    public DataOutputStream getOutputStream() {
        if (!this.opened) {
            log.error("getOutputStream called before load(), stream not available");
        }
        try {
            return new DataOutputStream(this.activeSerialPort.getOutputStream());
        }
        catch (IOException e) {
            log.error("getOutputStream exception: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public boolean status() {
        return this.opened;
    }

    protected void setSerialPort() throws UnsupportedCommOperationException {
        int baud = this.currentBaudNumber(this.mBaudRate);
        String opt1 = this.getOptionState(this.option1Name);
        if (!opt1.equals("CM11")) {
            if (opt1.equals("CP290")) {
                baud = 600;
            } else if (opt1.equals("Insteon 2412S")) {
                baud = 19200;
            }
        }
        this.activeSerialPort.setSerialPortParams(baud, 8, 1, 0);
        int flow = 0;
        this.configureLeadsAndFlowControl(this.activeSerialPort, flow);
    }

    @Override
    public String[] validBaudRates() {
        return Arrays.copyOf(this.validSpeeds, this.validSpeeds.length);
    }

    @Override
    public int[] validBaudNumbers() {
        return Arrays.copyOf(this.validSpeedValues, this.validSpeedValues.length);
    }

    @Override
    public int defaultBaudIndex() {
        return 0;
    }
}

