/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.insteon2412s;

import java.io.DataInputStream;
import java.io.IOException;
import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.powerline.InsteonSequence;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import jmri.jmrix.powerline.insteon2412s.SpecificMessage;
import jmri.jmrix.powerline.insteon2412s.SpecificReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificTrafficController
extends SerialTrafficController {
    private static final Logger log = LoggerFactory.getLogger(SpecificTrafficController.class);

    public SpecificTrafficController(SerialSystemConnectionMemo memo) {
        this.memo = memo;
        this.logDebug = log.isDebugEnabled();
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    @Override
    public synchronized void sendX10Sequence(X10Sequence s, SerialListener l) {
        X10Sequence.Command c;
        s.reset();
        while ((c = s.getCommand()) != null) {
            X10Sequence.Function f;
            SpecificMessage m = c.isAddress() ? SpecificMessage.getX10Address(c.getHouseCode(), ((X10Sequence.Address)c).getAddress()) : ((f = (X10Sequence.Function)c).getDimCount() > 0 ? SpecificMessage.getX10FunctionDim(f.getHouseCode(), f.getFunction(), f.getDimCount()) : SpecificMessage.getX10Function(f.getHouseCode(), f.getFunction()));
            this.sendSerialMessage(m, l);
            try {
                this.wait(250L);
            }
            catch (InterruptedException ex) {
                log.error(null, (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void sendInsteonSequence(InsteonSequence s, SerialListener l) {
        InsteonSequence.Command c;
        s.reset();
        while ((c = s.getCommand()) != null) {
            SpecificMessage m;
            if (c.isAddress()) {
                m = SpecificMessage.getInsteonAddress(-1, -1, -1);
            } else {
                InsteonSequence.Function f = (InsteonSequence.Function)c;
                m = SpecificMessage.getInsteonFunction(f.getAddressHigh(), f.getAddressMiddle(), f.getAddressLow(), f.getFunction(), f.getFlag(), f.getCommand1(), f.getCommand2());
            }
            this.sendSerialMessage(m, l);
        }
    }

    @Override
    public SerialMessage getSerialMessage(int length) {
        return new SpecificMessage(length);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        SpecificReply reply = new SpecificReply(this.memo.getTrafficController());
        return reply;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        if (msg.getNumDataElements() >= 2) {
            if (msg.getElement(0) != 2) {
                return false;
            }
            int cmd = msg.getElement(1);
            switch (msg.getNumDataElements()) {
                case 2: {
                    if (cmd != 85) break;
                    return true;
                }
                case 3: {
                    if (cmd != 84) break;
                    return true;
                }
                case 4: {
                    if (cmd != 82) break;
                    return true;
                }
                case 5: {
                    if (cmd != 99) break;
                    return true;
                }
                case 11: {
                    if (cmd != 80) break;
                    return true;
                }
                case 12: {
                    if (cmd != 98 || (msg.getElement(5) & 0x10) != 0) break;
                    return true;
                }
                case 25: {
                    if (cmd != 81) break;
                    return true;
                }
                case 26: {
                    if (cmd != 98 || (msg.getElement(5) & 0x10) != 16) break;
                    return true;
                }
            }
        }
        if (this.logDebug) {
            log.debug("end of message: {}", (Object)msg);
        }
        return false;
    }

    @Override
    protected void loadChars(AbstractMRReply msg, DataInputStream istream) throws IOException {
        byte char1 = this.readByteProtected(istream);
        if (this.logDebug) {
            log.debug("loadChars: {}", (Object)char1);
        }
        if ((char1 & 0xFF) == 2) {
            msg.setElement(0, char1);
            byte char2 = this.readByteProtected(istream);
            if ((char2 & 0xFF) == 98) {
                msg.setElement(1, char2);
                byte addr1 = this.readByteProtected(istream);
                msg.setElement(2, addr1);
                byte addr2 = this.readByteProtected(istream);
                msg.setElement(3, addr2);
                byte addr3 = this.readByteProtected(istream);
                msg.setElement(4, addr3);
                byte flag1 = this.readByteProtected(istream);
                msg.setElement(5, flag1);
                int bufsize = 3;
                if ((flag1 & 0x10) != 0) {
                    bufsize = 15;
                }
                int i = 6;
                while (i < 5 + bufsize) {
                    byte byt = this.readByteProtected(istream);
                    msg.setElement(i, byt);
                    ++i;
                }
            } else if ((char2 & 0xFF) == 99) {
                msg.setElement(1, char2);
                byte addrx1 = this.readByteProtected(istream);
                msg.setElement(2, addrx1);
                byte cmd1 = this.readByteProtected(istream);
                msg.setElement(3, cmd1);
                byte ack1 = this.readByteProtected(istream);
                msg.setElement(4, ack1);
            } else if ((char2 & 0xFF) == 80) {
                msg.setElement(1, char2);
                int i = 2;
                while (i < 11) {
                    byte byt = this.readByteProtected(istream);
                    msg.setElement(2, byt);
                    ++i;
                }
            } else if ((char2 & 0xFF) == 81) {
                msg.setElement(1, char2);
                int i = 2;
                while (i < 25) {
                    byte byt = this.readByteProtected(istream);
                    msg.setElement(2, byt);
                    ++i;
                }
            } else if ((char2 & 0xFF) == 82) {
                msg.setElement(1, char2);
                byte rawX10data = this.readByteProtected(istream);
                msg.setElement(2, rawX10data);
                byte x10Flag = this.readByteProtected(istream);
                msg.setElement(3, x10Flag);
                if ((x10Flag & 0xFF) == 128) {
                    if (this.logDebug) {
                        log.debug("loadChars: X10 Command Poll Received {} {}", (Object)X10Sequence.houseValueToText((rawX10data & 0xF0) >> 4), (Object)X10Sequence.functionName(rawX10data & 0xF));
                    }
                } else if (this.logDebug) {
                    log.debug("loadChars: X10 Unit Poll Received {} {}", (Object)X10Sequence.houseValueToText((rawX10data & 0xF0) >> 4), (Object)X10Sequence.formatCommandByte(rawX10data));
                }
            } else if ((char2 & 0xFF) == 84) {
                msg.setElement(1, char2);
                byte dat = this.readByteProtected(istream);
                msg.setElement(2, dat);
            } else if ((char2 & 0xFF) == 85) {
                msg.setElement(1, char2);
            } else {
                msg.setElement(1, char2);
                if (this.logDebug) {
                    log.debug("loadChars: Unknown cmd byte {}", (Object)char2);
                }
            }
        }
    }
}

