/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cp290;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import jmri.jmrix.powerline.cp290.SpecificMessage;
import jmri.jmrix.powerline.cp290.SpecificReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificTrafficController
extends SerialTrafficController {
    private boolean cmdOutstanding;
    private static final Logger log = LoggerFactory.getLogger(SpecificTrafficController.class);

    public SpecificTrafficController(SerialSystemConnectionMemo memo) {
        this.memo = memo;
        this.logDebug = log.isDebugEnabled();
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    @Override
    public synchronized void sendX10Sequence(X10Sequence s, SerialListener l) {
        s.reset();
        int devicemask = 0;
        X10Sequence.Command c = s.getCommand();
        if (c == null) {
            return;
        }
        int housecode = c.getHouseCode();
        devicemask = this.setDeviceBit(devicemask, ((X10Sequence.Address)c).getAddress());
        while ((c = s.getCommand()) != null && c.isAddress()) {
            if (housecode != ((X10Sequence.Address)c).getHouseCode()) {
                log.error("multiple housecodes found: {}, {}", (Object)housecode, (Object)c.getHouseCode());
                return;
            }
            devicemask = this.setDeviceBit(devicemask, ((X10Sequence.Address)c).getAddress());
        }
        if (c == null) {
            log.warn("no command");
            return;
        }
        this.formatAndSend(housecode, devicemask, (X10Sequence.Function)c, l);
        while ((c = s.getCommand()) != null && c.isFunction()) {
            if (housecode != ((X10Sequence.Function)c).getHouseCode()) {
                log.error("multiple housecodes found: {}, {}", (Object)housecode, (Object)c.getHouseCode());
                return;
            }
            this.formatAndSend(housecode, devicemask, (X10Sequence.Function)c, l);
        }
    }

    int setDeviceBit(int devicemask, int device) {
        return devicemask | 65536 >> device;
    }

    void formatAndSend(int housecode, int devicemask, X10Sequence.Function c, SerialListener l) {
        SpecificMessage m = new SpecificMessage(22);
        int i = 0;
        while (i < 16) {
            m.setElement(i, 255);
            ++i;
        }
        int level = c.getDimCount();
        if (level > 16) {
            log.warn("can't handle dim counts > 15?");
            level = 16;
        }
        if (this.logDebug) {
            log.debug("dim level: {}", (Object)level);
        }
        level = 16 - level;
        int function = c.getFunction();
        int lineHouseCode = X10Sequence.encode(housecode);
        m.setElement(16, 1);
        m.setElement(17, level * 16 + function);
        m.setElement(18, lineHouseCode * 16 + 0);
        m.setElement(19, devicemask & 0xFF);
        m.setElement(20, devicemask >> 8 & 0xFF);
        m.setElement(21, 0xFF & m.getElement(17) + m.getElement(18) + m.getElement(19) + m.getElement(20));
        this.sendSerialMessage(m, l);
        this.cmdOutstanding = true;
    }

    @Override
    public int getNumberOfIntensitySteps() {
        return 16;
    }

    @Override
    public SerialMessage getSerialMessage(int length) {
        return new SpecificMessage(length);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        SpecificReply reply = new SpecificReply(this.memo.getTrafficController());
        return reply;
    }

    @Override
    protected boolean endOfMessage(AbstractMRReply msg) {
        int syncCount = 0;
        int i = 0;
        while (i < msg.getNumDataElements()) {
            if ((msg.getElement(i) & 0xFF) != 255) break;
            ++syncCount;
            ++i;
        }
        if (this.cmdOutstanding) {
            if (syncCount == 6 && msg.getNumDataElements() == 7) {
                this.cmdOutstanding = false;
                return true;
            }
        } else if (syncCount == 6 && msg.getNumDataElements() == 12) {
            return true;
        }
        return false;
    }
}

