/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cp290;

import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialSensorManager;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificSensorManager
extends SerialSensorManager {
    private static final Logger log = LoggerFactory.getLogger(SpecificSensorManager.class);

    public SpecificSensorManager(SerialTrafficController tc) {
        super(tc);
    }

    @Override
    public synchronized void reply(SerialReply r) {
        this.processForPollReq(r);
    }

    private void processForPollReq(SerialReply m) {
        boolean goodSync = true;
        boolean goodCheckSum = true;
        int sum = 0;
        String newHouseCode = null;
        int newCmdCode = -1;
        int newAddrCode = -1;
        Sensor sensor = null;
        if (m.getNumDataElements() == 12) {
            int i = 0;
            while (i < 6) {
                if ((m.getElement(i) & 0xFF) != 255) {
                    goodSync = false;
                }
                ++i;
            }
            i = 7;
            while (i < 11) {
                sum = sum + (m.getElement(i) & 0xFF) & 0xFF;
                ++i;
            }
            if (sum != (m.getElement(11) & 0xFF)) {
                goodCheckSum = false;
            }
            newCmdCode = m.getElement(7) & 0xF;
            newHouseCode = X10Sequence.houseCodeToText(m.getElement(7) >> 4 & 0xF);
            newAddrCode = (m.getElement(8) & 0xFF) + ((m.getElement(9) & 0xFF) << 8);
            if (goodSync && goodCheckSum) {
                int unitMask = 65536;
                int unitCnt = 0;
                while (unitMask > 0) {
                    ++unitCnt;
                    int hCode = newAddrCode & (unitMask >>= 1);
                    if (hCode == 0) continue;
                    String sysName = String.valueOf(this.getSystemPrefix()) + "S" + newHouseCode + unitCnt;
                    sensor = this.provideSensor(sysName);
                    if (newCmdCode == 2 || newCmdCode == 5 || newCmdCode == 13) {
                        try {
                            sensor.setKnownState(2);
                        }
                        catch (JmriException e) {
                            log.error("Exception setting {} sensor ACTIVE: {}", (Object)sysName, (Object)e);
                        }
                    }
                    if (newCmdCode != 3 && newCmdCode != 4 && newCmdCode != 14) continue;
                    try {
                        sensor.setKnownState(4);
                    }
                    catch (JmriException e) {
                        log.error("Exception setting {} sensor INACTIVE: {}", (Object)sysName, (Object)e);
                    }
                }
            }
        }
    }
}

