/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cp290;

import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.X10Sequence;
import jmri.jmrix.powerline.cp290.Constants;

public class SpecificMessage
extends SerialMessage {
    int responseLength = -1;

    private SpecificMessage() {
    }

    public SpecificMessage(int l) {
        super(l);
        this.setResponseLength(0);
        this.setBinary(true);
        this.setTimeout(5000);
    }

    public SpecificMessage(String m, int l) {
        super(m, l);
    }

    public SpecificMessage(byte[] a, int l) {
        super(a, l);
    }

    int startIndex() {
        int len = this.getNumDataElements();
        int i = 0;
        while (i < len) {
            if ((this.getElement(i) & 0xFF) != 255) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String toMonitorString() {
        String test = Constants.toMonitorString(this);
        return "Send[" + this.getNumDataElements() + "]: " + test + "\n";
    }

    @Override
    public void setResponseLength(int l) {
        this.responseLength = l;
    }

    @Override
    public int getResponseLength() {
        return this.responseLength;
    }

    @Override
    public boolean isPoll() {
        return this.getElement(1) == 48;
    }

    @Override
    public boolean isXmt() {
        return this.getElement(1) == 17;
    }

    @Override
    public int getAddr() {
        return this.getElement(0);
    }

    public static SerialMessage getPoll(int addr) {
        return null;
    }

    public static SpecificMessage getAddress(int housecode, int devicecode) {
        SpecificMessage m = new SpecificMessage(2);
        m.setElement(0, 4);
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + X10Sequence.encode(devicecode));
        return m;
    }

    public static SpecificMessage getAddressDim(int housecode, int devicecode, int dimcode) {
        SpecificMessage m = new SpecificMessage(2);
        if (dimcode > 0) {
            m.setElement(0, 4 | (dimcode & 0x1F) << 3);
        } else {
            m.setElement(0, 4);
        }
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + X10Sequence.encode(devicecode));
        return m;
    }

    public static SpecificMessage getFunctionDim(int housecode, int function, int dimcode) {
        SpecificMessage m = new SpecificMessage(2);
        if (dimcode > 0) {
            m.setElement(0, 6 | (dimcode & 0x1F) << 3);
        } else {
            m.setElement(0, 6);
        }
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + function);
        return m;
    }

    public static SpecificMessage getFunction(int housecode, int function) {
        SpecificMessage m = new SpecificMessage(2);
        m.setElement(0, 6);
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + function);
        return m;
    }
}

