/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cp290;

import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.SerialX10Light;
import jmri.jmrix.powerline.X10Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificLight
extends SerialX10Light {
    SerialTrafficController tc = null;
    private static final Logger log = LoggerFactory.getLogger(SpecificLight.class);

    public SpecificLight(String systemName, SerialTrafficController tc) {
        super(systemName, tc);
        this.tc = tc;
        this.maxDimStep = tc.getNumberOfIntensitySteps();
    }

    public SpecificLight(String systemName, SerialTrafficController tc, String userName) {
        super(systemName, tc, userName);
        this.tc = tc;
        this.maxDimStep = tc.getNumberOfIntensitySteps();
    }

    @Override
    protected void initIntensity(double intensity) {
        this.maxDimStep = this.tc.getNumberOfIntensitySteps();
        if (intensity <= 0.5) {
            X10Sequence out = new X10Sequence();
            out.addAddress(this.housecode, this.devicecode);
            out.addFunction(this.housecode, 3, 0);
            out.addFunction(this.housecode, 4, this.maxDimStep);
            this.tc.sendX10Sequence(out, null);
            this.lastOutputStep = 0;
            if (log.isDebugEnabled()) {
                log.debug("initIntensity: sent dim reset");
            }
        } else {
            X10Sequence out = new X10Sequence();
            out.addAddress(this.housecode, this.devicecode);
            out.addFunction(this.housecode, 2, 0);
            out.addFunction(this.housecode, 5, this.maxDimStep);
            this.tc.sendX10Sequence(out, null);
            this.lastOutputStep = this.maxDimStep;
            if (log.isDebugEnabled()) {
                log.debug("initIntensity: sent bright reset");
            }
        }
    }
}

