/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cp290;

import jmri.jmrix.Message;

public class Constants {
    public static final int CMD_ON = 2;
    public static final int CMD_OFF = 3;
    public static final int CMD_DIM_R = 4;
    public static final int CMD_DIM_S = 5;

    public static String commandToText(int cmd, int level) {
        String cmdText = "";
        switch (cmd) {
            case 2: {
                cmdText = "ON";
                break;
            }
            case 3: {
                cmdText = "OFF";
                break;
            }
            case 4: {
                cmdText = "recvDIM";
                cmdText = String.valueOf(cmdText) + " ";
                break;
            }
            case 5: {
                cmdText = "sendDIM";
                int v2 = level * 100 / 16;
                cmdText = String.valueOf(cmdText) + " " + v2 + "%";
                break;
            }
            default: {
                cmdText = "Unk Cmd: " + cmd;
            }
        }
        return cmdText;
    }

    public static String houseCodeToText(int hC) {
        String hCode = "";
        switch (hC) {
            case 6: {
                hCode = "A";
                break;
            }
            case 14: {
                hCode = "B";
                break;
            }
            case 2: {
                hCode = "C";
                break;
            }
            case 10: {
                hCode = "D";
                break;
            }
            case 1: {
                hCode = "E";
                break;
            }
            case 9: {
                hCode = "F";
                break;
            }
            case 5: {
                hCode = "G";
                break;
            }
            case 13: {
                hCode = "H";
                break;
            }
            case 7: {
                hCode = "I";
                break;
            }
            case 15: {
                hCode = "J";
                break;
            }
            case 3: {
                hCode = "K";
                break;
            }
            case 11: {
                hCode = "L";
                break;
            }
            case 0: {
                hCode = "M";
                break;
            }
            case 8: {
                hCode = "N";
                break;
            }
            case 4: {
                hCode = "O";
                break;
            }
            case 12: {
                hCode = "P";
                break;
            }
            default: {
                hCode = "Unk hC:" + hC;
            }
        }
        return hCode;
    }

    public static String deviceToText(int hByte, int lByte) {
        int mask = 1;
        int x = lByte;
        StringBuilder dev = new StringBuilder();
        int i = 8;
        while (i > 0) {
            if ((x & mask) != 0) {
                dev.append(" " + i);
            }
            mask <<= 1;
            --i;
        }
        mask = 1;
        x = hByte;
        i = 16;
        while (i > 8) {
            if ((x & mask) != 0) {
                dev.append(" " + i);
            }
            mask <<= 1;
            --i;
        }
        return dev.toString();
    }

    public static String statusToText(int s) {
        String stat = "";
        switch (s) {
            case 0: {
                stat = "Interface Powered Off";
                break;
            }
            case 1: {
                stat = "Cmd Ok";
                break;
            }
            default: {
                stat = "Unk Status: " + s;
            }
        }
        return stat;
    }

    public static String toMonitorString(Message m) {
        String val = "???";
        int len = m.getNumDataElements();
        boolean goodSync = true;
        boolean goodCheckSum = true;
        int sum = 0;
        switch (len) {
            case 7: {
                int i = 0;
                while (i < 6) {
                    if ((m.getElement(i) & 0xFF) != 255) {
                        goodSync = false;
                    }
                    ++i;
                }
                val = Constants.statusToText(m.getElement(6));
                break;
            }
            case 12: {
                int i = 0;
                while (i < 6) {
                    if ((m.getElement(i) & 0xFF) != 255) {
                        goodSync = false;
                    }
                    ++i;
                }
                i = 7;
                while (i < 11) {
                    sum = sum + (m.getElement(i) & 0xFF) & 0xFF;
                    ++i;
                }
                String stat = Constants.statusToText(m.getElement(6));
                String cmd = Constants.commandToText(m.getElement(7) & 0xF, -1);
                String hCode = Constants.houseCodeToText(m.getElement(7) >> 4 & 0xF);
                String dev = Constants.deviceToText(m.getElement(8), m.getElement(9));
                String bCode = Constants.houseCodeToText(m.getElement(10) >> 4 & 0xF);
                if (sum != (m.getElement(11) & 0xFF)) {
                    goodCheckSum = false;
                }
                val = "Cmd Echo: " + cmd + " stat: " + stat + " House: " + hCode + " Device:" + dev + " base: " + bCode;
                if (!goodSync) {
                    val = String.valueOf(val) + " BAD SYNC";
                }
                if (goodCheckSum) break;
                val = String.valueOf(val) + " BAD CHECKSUM: " + (m.getElement(11) & 0xFF) + " vs " + sum;
                break;
            }
            case 22: {
                int i = 0;
                while (i < 16) {
                    if ((m.getElement(i) & 0xFF) != 255) {
                        goodSync = false;
                    }
                    ++i;
                }
                i = 17;
                while (i < 21) {
                    sum = sum + (m.getElement(i) & 0xFF) & 0xFF;
                    ++i;
                }
                String cmd = Constants.commandToText(m.getElement(17) & 0xF, (m.getElement(17) & 0xF0) >> 4);
                String hCode = Constants.houseCodeToText(m.getElement(18) >> 4 & 0xF);
                String dev = Constants.deviceToText(m.getElement(19), m.getElement(20));
                if (sum != (m.getElement(21) & 0xFF)) {
                    goodCheckSum = false;
                }
                val = String.valueOf(cmd) + " House: " + hCode + " Device:" + dev;
                if (!goodSync) {
                    val = String.valueOf(val) + " BAD SYNC";
                }
                if (goodCheckSum) break;
                val = String.valueOf(val) + " BAD CHECKSUM: " + (m.getElement(21) & 0xFF) + " vs " + sum;
                break;
            }
            default: {
                val = "UNK " + m.toString();
            }
        }
        return val;
    }
}

