/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cm11;

import jmri.jmrix.AbstractMRListener;
import jmri.jmrix.AbstractMRMessage;
import jmri.jmrix.AbstractMRReply;
import jmri.jmrix.powerline.SerialListener;
import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.SerialSystemConnectionMemo;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import jmri.jmrix.powerline.cm11.SpecificMessage;
import jmri.jmrix.powerline.cm11.SpecificReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecificTrafficController
extends SerialTrafficController {
    boolean sendInterlock = false;
    boolean expectLength = false;
    boolean countingBytes = false;
    int remainingBytes = 0;
    private static final Logger log = LoggerFactory.getLogger(SpecificTrafficController.class);

    public SpecificTrafficController(SerialSystemConnectionMemo memo) {
        this.memo = memo;
        this.logDebug = log.isDebugEnabled();
        this.setAllowUnexpectedReply(true);
        this.mWaitBeforePoll = 1000;
    }

    @Override
    public synchronized void sendX10Sequence(X10Sequence s, SerialListener l) {
        X10Sequence.Command c;
        s.reset();
        while ((c = s.getCommand()) != null) {
            SpecificMessage m;
            if (c.isAddress()) {
                m = SpecificMessage.getAddress(c.getHouseCode(), ((X10Sequence.Address)c).getAddress());
            } else if (c.isFunction()) {
                X10Sequence.Function f = (X10Sequence.Function)c;
                m = f.getDimCount() > 0 ? SpecificMessage.getFunctionDim(f.getHouseCode(), f.getFunction(), f.getDimCount()) : SpecificMessage.getFunction(f.getHouseCode(), f.getFunction());
            } else {
                X10Sequence.ExtData e = (X10Sequence.ExtData)c;
                m = SpecificMessage.getExtCmd(c.getHouseCode(), e.getAddress(), e.getExtCmd(), e.getExtData());
            }
            this.sendSerialMessage(m, l);
        }
    }

    @Override
    public int getNumberOfIntensitySteps() {
        return 63;
    }

    @Override
    public SerialMessage getSerialMessage(int length) {
        return new SpecificMessage(length);
    }

    @Override
    protected void forwardToPort(AbstractMRMessage m, AbstractMRListener reply) {
        if (this.logDebug) {
            log.debug("forward {}", (Object)m);
        }
        this.sendInterlock = ((SerialMessage)m).getInterlocked();
        super.forwardToPort(m, reply);
    }

    @Override
    protected AbstractMRReply newReply() {
        SpecificReply reply = new SpecificReply(this.memo.getTrafficController());
        return reply;
    }

    @Override
    public boolean endOfMessage(AbstractMRReply msg) {
        if (this.expectLength) {
            this.expectLength = false;
            this.countingBytes = true;
            this.remainingBytes = msg.getElement(1) & 0xF;
            if (this.logDebug) {
                log.debug("Receive count set to {}", (Object)this.remainingBytes);
            }
            return false;
        }
        if (this.remainingBytes > 0) {
            if (this.remainingBytes > 8) {
                log.error("Invalid remainingBytes: {}", (Object)this.remainingBytes);
                this.remainingBytes = 0;
                return true;
            }
            --this.remainingBytes;
            if (this.remainingBytes == 0) {
                this.countingBytes = false;
                return true;
            }
            return false;
        }
        if ((msg.getElement(0) & 0xFF) == 90) {
            SpecificMessage m = new SpecificMessage(1);
            m.setElement(0, 195);
            this.expectLength = true;
            this.forwardToPort(m, null);
            return false;
        }
        if ((msg.getElement(0) & 0xFF) == 166 || (msg.getElement(0) & 0xFF) == 165) {
            SpecificMessage m = SpecificMessage.setCM11Time(X10Sequence.encode(1));
            this.forwardToPort(m, null);
            return true;
        }
        if ((msg.getElement(0) & 0xFF) == 91) {
            return msg.getNumDataElements() >= 3;
        }
        if (this.sendInterlock) {
            if (this.logDebug) {
                log.debug("Send interlock");
            }
            this.sendInterlock = false;
            SpecificMessage m = new SpecificMessage(1);
            m.setElement(0, 0);
            this.forwardToPort(m, null);
            return false;
        }
        if (this.logDebug) {
            log.debug("end of message: {}", (Object)msg);
        }
        return true;
    }
}

