/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cm11;

import jmri.jmrix.powerline.SerialReply;
import jmri.jmrix.powerline.SerialTrafficController;
import jmri.jmrix.powerline.X10Sequence;
import jmri.util.StringUtil;

public class SpecificReply
extends SerialReply {
    public SpecificReply(SerialTrafficController tc) {
        super(tc);
        this.setBinary(true);
    }

    public SpecificReply(String s, SerialTrafficController tc) {
        super(tc, s);
        this.setBinary(true);
    }

    public SpecificReply(SerialReply l, SerialTrafficController tc) {
        super(tc, l);
        this.setBinary(true);
    }

    @Override
    public String toMonitorString() {
        StringBuilder sb = new StringBuilder();
        if (this.getNumDataElements() == 1) {
            int msg = this.getElement(0);
            switch (msg & 0xFF) {
                case 90: {
                    sb.append("Data Available\n");
                    break;
                }
                case 165: {
                    sb.append("CP11 time request\n");
                    break;
                }
                case 166: {
                    sb.append("CP10 time request\n");
                    break;
                }
                case 243: {
                    sb.append("Input Filter Failed\n");
                    break;
                }
                case 85: {
                    sb.append("Interface Ready\n");
                    break;
                }
                default: {
                    sb.append("One byte, probably CRC\n");
                }
            }
            return sb.toString();
        }
        if (this.getNumDataElements() == 2 && (this.getElement(1) & 0xFF) == 85) {
            sb.append("CRC 0x");
            sb.append(StringUtil.twoHexFromInt(this.getElement(0)));
            sb.append(" and Interface Ready\n");
            return sb.toString();
        }
        if ((this.getElement(0) & 0xFF) == 90) {
            sb.append("Receive data, ");
            sb.append(this.getElement(1) & 0xFF);
            sb.append(" bytes; ");
            int last = (this.getElement(1) & 0xFF) + 1;
            int bits = this.getElement(2) & 0xFF;
            int i = 3;
            while (i <= last) {
                if (i != 3) {
                    sb.append("; ");
                }
                if ((bits & 1) != 0) {
                    sb.append(X10Sequence.formatCommandByte(this.getElement(i) & 0xFF));
                } else {
                    sb.append(X10Sequence.formatAddressByte(this.getElement(i) & 0xFF));
                }
                bits >>= 1;
                ++i;
            }
            sb.append("\n");
            return sb.toString();
        }
        if ((this.getElement(0) & 0xFF) == 91) {
            if (this.getNumDataElements() == 3) {
                sb.append("EPROM Address Poll: ");
                sb.append(StringUtil.twoHexFromInt(this.getElement(1) & 0xFF));
                sb.append(":");
                sb.append(StringUtil.twoHexFromInt(this.getElement(2) & 0xFF));
                sb.append("\n");
                return sb.toString();
            }
            sb.append("EPROM Address Poll, invalid length: ");
            sb.append(this.getNumDataElements());
            return sb.toString();
        }
        sb.append("Unknown reply of length ");
        sb.append(this.getNumDataElements());
        sb.append(" ");
        sb.append(this.toString()).append("\n");
        sb.append("\n");
        return sb.toString();
    }
}

