/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrix.powerline.cm11;

import jmri.jmrix.powerline.SerialMessage;
import jmri.jmrix.powerline.X10Sequence;
import jmri.jmrix.powerline.cm11.Constants;
import jmri.util.StringUtil;

public class SpecificMessage
extends SerialMessage {
    boolean interlocked = false;
    int responseLength = -1;

    private SpecificMessage() {
    }

    public SpecificMessage(int l) {
        super(l);
        this.setResponseLength(0);
        this.setBinary(true);
        this.setTimeout(5000);
    }

    public SpecificMessage(String m, int l) {
        super(m, l);
    }

    @Override
    public void setInterlocked(boolean v) {
        this.interlocked = v;
    }

    @Override
    public boolean getInterlocked() {
        return this.interlocked;
    }

    @Override
    public String toMonitorString() {
        int len = this.getNumDataElements();
        StringBuilder text = new StringBuilder();
        block0 : switch (this.getElement(0) & 0xFF) {
            case 251: {
                text.append("Macro load reply");
                break;
            }
            case 91: {
                text.append("Macro Poll");
                break;
            }
            case 165: {
                text.append("Power Fail Poll");
                break;
            }
            case 155: {
                text.append("Set CM11 time");
                break;
            }
            case 7: {
                text.append("Extended Cmd");
                if (len == 5) {
                    text.append(" house ");
                    text.append(X10Sequence.houseValueToText(X10Sequence.decode(this.getElement(1) >> 4 & 0xF)));
                    text.append(" address device ");
                    text.append(X10Sequence.decode(this.getElement(2) & 0xF));
                    int d = this.getElement(3) & 0xFF;
                    switch (this.getElement(4) & 0xFF) {
                        case 49: {
                            text.append(" Direct Dim: ");
                            if ((d & 0x3F) <= 62) {
                                text.append(String.valueOf((double)(d & 0x3F) / 0.63) + "%");
                                break block0;
                            }
                            if (d == 63) {
                                text.append("Full On");
                                break block0;
                            }
                            text.append(" data: 0x");
                            text.append(StringUtil.twoHexFromInt(d));
                            break block0;
                        }
                    }
                    text.append(" cmd: 0x");
                    text.append(StringUtil.twoHexFromInt(this.getElement(4) & 0xFF));
                    text.append(" data: 0x");
                    text.append(StringUtil.twoHexFromInt(this.getElement(3) & 0xFF));
                    break;
                }
                text.append(" wrong length: " + len);
                break;
            }
            case 195: {
                if (len == 1) {
                    text.append("Poll Ack");
                    break;
                }
            }
            case 0: {
                if (len == 1) {
                    text.append("OK for transmission");
                    break;
                }
            }
            default: {
                if (len == 2) {
                    text.append(Constants.formatHeaderByte(this.getElement(0)));
                    if ((this.getElement(0) & 2) == 2) {
                        text.append(" ");
                        text.append(X10Sequence.formatCommandByte(this.getElement(1) & 0xFF));
                        break;
                    }
                    text.append(" ");
                    text.append(X10Sequence.formatAddressByte(this.getElement(1) & 0xFF));
                    break;
                }
                text.append("Reply was not expected, len: " + len);
                text.append(" value: " + Constants.formatHeaderByte(this.getElement(0)));
            }
        }
        return text + "\n";
    }

    public SpecificMessage(byte[] a, int l) {
        super(a, l);
    }

    @Override
    public void setResponseLength(int l) {
        this.responseLength = l;
    }

    @Override
    public int getResponseLength() {
        return this.responseLength;
    }

    @Override
    public boolean isPoll() {
        return this.getElement(1) == 48;
    }

    @Override
    public boolean isXmt() {
        return this.getElement(1) == 17;
    }

    @Override
    public int getAddr() {
        return this.getElement(0);
    }

    public static SerialMessage getPoll(int addr) {
        return null;
    }

    public static SpecificMessage setCM11Time(int housecode) {
        SpecificMessage msg = new SpecificMessage(7);
        msg.setElement(0, 155);
        msg.setElement(5, 1);
        msg.setElement(6, housecode << 4);
        return msg;
    }

    public static SpecificMessage getAddress(int housecode, int devicecode) {
        SpecificMessage m = new SpecificMessage(2);
        m.setInterlocked(true);
        m.setElement(0, 4);
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + X10Sequence.encode(devicecode));
        return m;
    }

    public static SpecificMessage getAddressDim(int housecode, int devicecode, int dimcode) {
        SpecificMessage m = new SpecificMessage(2);
        m.setInterlocked(true);
        if (dimcode > 0) {
            m.setElement(0, 4 | (dimcode & 0x1F) << 3);
        } else {
            m.setElement(0, 4);
        }
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + X10Sequence.encode(devicecode));
        return m;
    }

    public static SpecificMessage getFunctionDim(int housecode, int function, int dimcode) {
        SpecificMessage m = new SpecificMessage(2);
        m.setInterlocked(true);
        if (dimcode > 0) {
            m.setElement(0, 6 | (dimcode & 0x1F) << 3);
        } else {
            m.setElement(0, 6);
        }
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + function);
        return m;
    }

    public static SpecificMessage getFunction(int housecode, int function) {
        SpecificMessage m = new SpecificMessage(2);
        m.setInterlocked(true);
        m.setElement(0, 6);
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + function);
        return m;
    }

    public static SpecificMessage getExtCmd(int housecode, int devicecode, int function, int dimcode) {
        SpecificMessage m = new SpecificMessage(5);
        m.setInterlocked(true);
        m.setElement(0, 7);
        m.setElement(1, (X10Sequence.encode(housecode) << 4) + 7);
        m.setElement(2, X10Sequence.encode(devicecode));
        m.setElement(3, dimcode);
        m.setElement(4, function);
        return m;
    }
}

